/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TeamMember;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateTeamMemberRequest {
    private final Optional<String> idempotencyKey;
    private final Optional<TeamMember> teamMember;
    private final Map<String, Object> additionalProperties;

    private CreateTeamMemberRequest(Optional<String> idempotencyKey, Optional<TeamMember> teamMember, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.teamMember = teamMember;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="team_member")
    public Optional<TeamMember> getTeamMember() {
        return this.teamMember;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateTeamMemberRequest && this.equalTo((CreateTeamMemberRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateTeamMemberRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.teamMember.equals(other.teamMember);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.teamMember);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> idempotencyKey = Optional.empty();
        private Optional<TeamMember> teamMember = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateTeamMemberRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.teamMember(other.getTeamMember());
            return this;
        }

        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public Builder idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @JsonSetter(value="team_member", nulls=Nulls.SKIP)
        public Builder teamMember(Optional<TeamMember> teamMember) {
            this.teamMember = teamMember;
            return this;
        }

        public Builder teamMember(TeamMember teamMember) {
            this.teamMember = Optional.ofNullable(teamMember);
            return this;
        }

        public CreateTeamMemberRequest build() {
            return new CreateTeamMemberRequest(this.idempotencyKey, this.teamMember, this.additionalProperties);
        }
    }
}

