/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ScheduledShift;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateScheduledShiftRequest {
    private final Optional<String> idempotencyKey;
    private final ScheduledShift scheduledShift;
    private final Map<String, Object> additionalProperties;

    private CreateScheduledShiftRequest(Optional<String> idempotencyKey, ScheduledShift scheduledShift, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.scheduledShift = scheduledShift;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="scheduled_shift")
    public ScheduledShift getScheduledShift() {
        return this.scheduledShift;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateScheduledShiftRequest && this.equalTo((CreateScheduledShiftRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateScheduledShiftRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.scheduledShift.equals(other.scheduledShift);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.scheduledShift);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ScheduledShiftStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ScheduledShiftStage,
    _FinalStage {
        private ScheduledShift scheduledShift;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateScheduledShiftRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.scheduledShift(other.getScheduledShift());
            return this;
        }

        @Override
        @JsonSetter(value="scheduled_shift")
        public _FinalStage scheduledShift(@NotNull ScheduledShift scheduledShift) {
            this.scheduledShift = Objects.requireNonNull(scheduledShift, "scheduledShift must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public CreateScheduledShiftRequest build() {
            return new CreateScheduledShiftRequest(this.idempotencyKey, this.scheduledShift, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateScheduledShiftRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);
    }

    public static interface ScheduledShiftStage {
        public _FinalStage scheduledShift(@NotNull ScheduledShift var1);

        public Builder from(CreateScheduledShiftRequest var1);
    }
}

