/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.PaymentLink;
import com.squareup.square.types.PaymentLinkRelatedResources;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreatePaymentLinkResponse {
    private final Optional<List<Error>> errors;
    private final Optional<PaymentLink> paymentLink;
    private final Optional<PaymentLinkRelatedResources> relatedResources;
    private final Map<String, Object> additionalProperties;

    private CreatePaymentLinkResponse(Optional<List<Error>> errors, Optional<PaymentLink> paymentLink, Optional<PaymentLinkRelatedResources> relatedResources, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.paymentLink = paymentLink;
        this.relatedResources = relatedResources;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="payment_link")
    public Optional<PaymentLink> getPaymentLink() {
        return this.paymentLink;
    }

    @JsonProperty(value="related_resources")
    public Optional<PaymentLinkRelatedResources> getRelatedResources() {
        return this.relatedResources;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreatePaymentLinkResponse && this.equalTo((CreatePaymentLinkResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreatePaymentLinkResponse other) {
        return this.errors.equals(other.errors) && this.paymentLink.equals(other.paymentLink) && this.relatedResources.equals(other.relatedResources);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.paymentLink, this.relatedResources);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<PaymentLink> paymentLink = Optional.empty();
        private Optional<PaymentLinkRelatedResources> relatedResources = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreatePaymentLinkResponse other) {
            this.errors(other.getErrors());
            this.paymentLink(other.getPaymentLink());
            this.relatedResources(other.getRelatedResources());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="payment_link", nulls=Nulls.SKIP)
        public Builder paymentLink(Optional<PaymentLink> paymentLink) {
            this.paymentLink = paymentLink;
            return this;
        }

        public Builder paymentLink(PaymentLink paymentLink) {
            this.paymentLink = Optional.ofNullable(paymentLink);
            return this;
        }

        @JsonSetter(value="related_resources", nulls=Nulls.SKIP)
        public Builder relatedResources(Optional<PaymentLinkRelatedResources> relatedResources) {
            this.relatedResources = relatedResources;
            return this;
        }

        public Builder relatedResources(PaymentLinkRelatedResources relatedResources) {
            this.relatedResources = Optional.ofNullable(relatedResources);
            return this;
        }

        public CreatePaymentLinkResponse build() {
            return new CreatePaymentLinkResponse(this.errors, this.paymentLink, this.relatedResources, this.additionalProperties);
        }
    }
}

