/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Order;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateOrderRequest {
    private final Optional<Order> order;
    private final Optional<String> idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private CreateOrderRequest(Optional<Order> order, Optional<String> idempotencyKey, Map<String, Object> additionalProperties) {
        this.order = order;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order")
    public Optional<Order> getOrder() {
        return this.order;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateOrderRequest && this.equalTo((CreateOrderRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateOrderRequest other) {
        return this.order.equals(other.order) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Order> order = Optional.empty();
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateOrderRequest other) {
            this.order(other.getOrder());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public Builder order(Optional<Order> order) {
            this.order = order;
            return this;
        }

        public Builder order(Order order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public Builder idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        public CreateOrderRequest build() {
            return new CreateOrderRequest(this.order, this.idempotencyKey, this.additionalProperties);
        }
    }
}

