/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Job;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateJobResponse {
    private final Optional<Job> job;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private CreateJobResponse(Optional<Job> job, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.job = job;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="job")
    public Optional<Job> getJob() {
        return this.job;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateJobResponse && this.equalTo((CreateJobResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateJobResponse other) {
        return this.job.equals(other.job) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.job, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Job> job = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateJobResponse other) {
            this.job(other.getJob());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="job", nulls=Nulls.SKIP)
        public Builder job(Optional<Job> job) {
            this.job = job;
            return this;
        }

        public Builder job(Job job) {
            this.job = Optional.ofNullable(job);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public CreateJobResponse build() {
            return new CreateJobResponse(this.job, this.errors, this.additionalProperties);
        }
    }
}

