/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CreateInvoiceAttachmentRequestData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateInvoiceAttachmentRequest {
    private final Optional<File> imageFile;
    private final String invoiceId;
    private final Optional<CreateInvoiceAttachmentRequestData> request;
    private final Map<String, Object> additionalProperties;

    private CreateInvoiceAttachmentRequest(Optional<File> imageFile, String invoiceId, Optional<CreateInvoiceAttachmentRequestData> request, Map<String, Object> additionalProperties) {
        this.imageFile = imageFile;
        this.invoiceId = invoiceId;
        this.request = request;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="image_file")
    public Optional<File> getImageFile() {
        return this.imageFile;
    }

    @JsonProperty(value="invoice_id")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonProperty(value="request")
    public Optional<CreateInvoiceAttachmentRequestData> getRequest() {
        return this.request;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateInvoiceAttachmentRequest && this.equalTo((CreateInvoiceAttachmentRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateInvoiceAttachmentRequest other) {
        return this.imageFile.equals(other.imageFile) && this.invoiceId.equals(other.invoiceId) && this.request.equals(other.request);
    }

    public int hashCode() {
        return Objects.hash(this.imageFile, this.invoiceId, this.request);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InvoiceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements InvoiceIdStage,
    _FinalStage {
        private String invoiceId;
        private Optional<CreateInvoiceAttachmentRequestData> request = Optional.empty();
        private Optional<File> imageFile = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateInvoiceAttachmentRequest other) {
            this.imageFile(other.getImageFile());
            this.invoiceId(other.getInvoiceId());
            this.request(other.getRequest());
            return this;
        }

        @Override
        @JsonSetter(value="invoice_id")
        public _FinalStage invoiceId(@NotNull String invoiceId) {
            this.invoiceId = Objects.requireNonNull(invoiceId, "invoiceId must not be null");
            return this;
        }

        @Override
        public _FinalStage request(CreateInvoiceAttachmentRequestData request) {
            this.request = Optional.ofNullable(request);
            return this;
        }

        @Override
        @JsonSetter(value="request", nulls=Nulls.SKIP)
        public _FinalStage request(Optional<CreateInvoiceAttachmentRequestData> request) {
            this.request = request;
            return this;
        }

        @Override
        public _FinalStage imageFile(File imageFile) {
            this.imageFile = Optional.ofNullable(imageFile);
            return this;
        }

        @Override
        @JsonSetter(value="image_file", nulls=Nulls.SKIP)
        public _FinalStage imageFile(Optional<File> imageFile) {
            this.imageFile = imageFile;
            return this;
        }

        @Override
        public CreateInvoiceAttachmentRequest build() {
            return new CreateInvoiceAttachmentRequest(this.imageFile, this.invoiceId, this.request, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateInvoiceAttachmentRequest build();

        public _FinalStage imageFile(Optional<File> var1);

        public _FinalStage imageFile(File var1);

        public _FinalStage request(Optional<CreateInvoiceAttachmentRequestData> var1);

        public _FinalStage request(CreateInvoiceAttachmentRequestData var1);
    }

    public static interface InvoiceIdStage {
        public _FinalStage invoiceId(@NotNull String var1);

        public Builder from(CreateInvoiceAttachmentRequest var1);
    }
}

