/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DisputeEvidenceType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateDisputeEvidenceTextRequest {
    private final String disputeId;
    private final String idempotencyKey;
    private final Optional<DisputeEvidenceType> evidenceType;
    private final String evidenceText;
    private final Map<String, Object> additionalProperties;

    private CreateDisputeEvidenceTextRequest(String disputeId, String idempotencyKey, Optional<DisputeEvidenceType> evidenceType, String evidenceText, Map<String, Object> additionalProperties) {
        this.disputeId = disputeId;
        this.idempotencyKey = idempotencyKey;
        this.evidenceType = evidenceType;
        this.evidenceText = evidenceText;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="dispute_id")
    public String getDisputeId() {
        return this.disputeId;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="evidence_type")
    public Optional<DisputeEvidenceType> getEvidenceType() {
        return this.evidenceType;
    }

    @JsonProperty(value="evidence_text")
    public String getEvidenceText() {
        return this.evidenceText;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateDisputeEvidenceTextRequest && this.equalTo((CreateDisputeEvidenceTextRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateDisputeEvidenceTextRequest other) {
        return this.disputeId.equals(other.disputeId) && this.idempotencyKey.equals(other.idempotencyKey) && this.evidenceType.equals(other.evidenceType) && this.evidenceText.equals(other.evidenceText);
    }

    public int hashCode() {
        return Objects.hash(this.disputeId, this.idempotencyKey, this.evidenceType, this.evidenceText);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DisputeIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DisputeIdStage,
    IdempotencyKeyStage,
    EvidenceTextStage,
    _FinalStage {
        private String disputeId;
        private String idempotencyKey;
        private String evidenceText;
        private Optional<DisputeEvidenceType> evidenceType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateDisputeEvidenceTextRequest other) {
            this.disputeId(other.getDisputeId());
            this.idempotencyKey(other.getIdempotencyKey());
            this.evidenceType(other.getEvidenceType());
            this.evidenceText(other.getEvidenceText());
            return this;
        }

        @Override
        @JsonSetter(value="dispute_id")
        public IdempotencyKeyStage disputeId(@NotNull String disputeId) {
            this.disputeId = Objects.requireNonNull(disputeId, "disputeId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public EvidenceTextStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="evidence_text")
        public _FinalStage evidenceText(@NotNull String evidenceText) {
            this.evidenceText = Objects.requireNonNull(evidenceText, "evidenceText must not be null");
            return this;
        }

        @Override
        public _FinalStage evidenceType(DisputeEvidenceType evidenceType) {
            this.evidenceType = Optional.ofNullable(evidenceType);
            return this;
        }

        @Override
        @JsonSetter(value="evidence_type", nulls=Nulls.SKIP)
        public _FinalStage evidenceType(Optional<DisputeEvidenceType> evidenceType) {
            this.evidenceType = evidenceType;
            return this;
        }

        @Override
        public CreateDisputeEvidenceTextRequest build() {
            return new CreateDisputeEvidenceTextRequest(this.disputeId, this.idempotencyKey, this.evidenceType, this.evidenceText, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateDisputeEvidenceTextRequest build();

        public _FinalStage evidenceType(Optional<DisputeEvidenceType> var1);

        public _FinalStage evidenceType(DisputeEvidenceType var1);
    }

    public static interface EvidenceTextStage {
        public _FinalStage evidenceText(@NotNull String var1);
    }

    public static interface IdempotencyKeyStage {
        public EvidenceTextStage idempotencyKey(@NotNull String var1);
    }

    public static interface DisputeIdStage {
        public IdempotencyKeyStage disputeId(@NotNull String var1);

        public Builder from(CreateDisputeEvidenceTextRequest var1);
    }
}

