/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCatalogImageRequest {
    private final String idempotencyKey;
    private final Optional<String> objectId;
    private final CatalogObject image;
    private final Optional<Boolean> isPrimary;
    private final Map<String, Object> additionalProperties;

    private CreateCatalogImageRequest(String idempotencyKey, Optional<String> objectId, CatalogObject image, Optional<Boolean> isPrimary, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.objectId = objectId;
        this.image = image;
        this.isPrimary = isPrimary;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="object_id")
    public Optional<String> getObjectId() {
        return this.objectId;
    }

    @JsonProperty(value="image")
    public CatalogObject getImage() {
        return this.image;
    }

    @JsonProperty(value="is_primary")
    public Optional<Boolean> getIsPrimary() {
        return this.isPrimary;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCatalogImageRequest && this.equalTo((CreateCatalogImageRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCatalogImageRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.objectId.equals(other.objectId) && this.image.equals(other.image) && this.isPrimary.equals(other.isPrimary);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.objectId, this.image, this.isPrimary);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    ImageStage,
    _FinalStage {
        private String idempotencyKey;
        private CatalogObject image;
        private Optional<Boolean> isPrimary = Optional.empty();
        private Optional<String> objectId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateCatalogImageRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.objectId(other.getObjectId());
            this.image(other.getImage());
            this.isPrimary(other.getIsPrimary());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public ImageStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="image")
        public _FinalStage image(@NotNull CatalogObject image) {
            this.image = Objects.requireNonNull(image, "image must not be null");
            return this;
        }

        @Override
        public _FinalStage isPrimary(Boolean isPrimary) {
            this.isPrimary = Optional.ofNullable(isPrimary);
            return this;
        }

        @Override
        @JsonSetter(value="is_primary", nulls=Nulls.SKIP)
        public _FinalStage isPrimary(Optional<Boolean> isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        @Override
        public _FinalStage objectId(String objectId) {
            this.objectId = Optional.ofNullable(objectId);
            return this;
        }

        @Override
        @JsonSetter(value="object_id", nulls=Nulls.SKIP)
        public _FinalStage objectId(Optional<String> objectId) {
            this.objectId = objectId;
            return this;
        }

        @Override
        public CreateCatalogImageRequest build() {
            return new CreateCatalogImageRequest(this.idempotencyKey, this.objectId, this.image, this.isPrimary, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateCatalogImageRequest build();

        public _FinalStage objectId(Optional<String> var1);

        public _FinalStage objectId(String var1);

        public _FinalStage isPrimary(Optional<Boolean> var1);

        public _FinalStage isPrimary(Boolean var1);
    }

    public static interface ImageStage {
        public _FinalStage image(@NotNull CatalogObject var1);
    }

    public static interface IdempotencyKeyStage {
        public ImageStage idempotencyKey(@NotNull String var1);

        public Builder from(CreateCatalogImageRequest var1);
    }
}

