/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Booking;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateBookingRequest {
    private final Optional<String> idempotencyKey;
    private final Booking booking;
    private final Map<String, Object> additionalProperties;

    private CreateBookingRequest(Optional<String> idempotencyKey, Booking booking, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.booking = booking;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="booking")
    public Booking getBooking() {
        return this.booking;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateBookingRequest && this.equalTo((CreateBookingRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBookingRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.booking.equals(other.booking);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.booking);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BookingStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BookingStage,
    _FinalStage {
        private Booking booking;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateBookingRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.booking(other.getBooking());
            return this;
        }

        @Override
        @JsonSetter(value="booking")
        public _FinalStage booking(@NotNull Booking booking) {
            this.booking = Objects.requireNonNull(booking, "booking must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public CreateBookingRequest build() {
            return new CreateBookingRequest(this.idempotencyKey, this.booking, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateBookingRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);
    }

    public static interface BookingStage {
        public _FinalStage booking(@NotNull Booking var1);

        public Builder from(CreateBookingRequest var1);
    }
}

