/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.AcceptedPaymentMethods;
import com.squareup.square.types.CustomField;
import com.squareup.square.types.Money;
import com.squareup.square.types.ShippingFee;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CheckoutOptions {
    private final Optional<Boolean> allowTipping;
    private final Optional<List<CustomField>> customFields;
    private final Optional<String> subscriptionPlanId;
    private final Optional<String> redirectUrl;
    private final Optional<String> merchantSupportEmail;
    private final Optional<Boolean> askForShippingAddress;
    private final Optional<AcceptedPaymentMethods> acceptedPaymentMethods;
    private final Optional<Money> appFeeMoney;
    private final Optional<ShippingFee> shippingFee;
    private final Optional<Boolean> enableCoupon;
    private final Optional<Boolean> enableLoyalty;
    private final Map<String, Object> additionalProperties;

    private CheckoutOptions(Optional<Boolean> allowTipping, Optional<List<CustomField>> customFields, Optional<String> subscriptionPlanId, Optional<String> redirectUrl, Optional<String> merchantSupportEmail, Optional<Boolean> askForShippingAddress, Optional<AcceptedPaymentMethods> acceptedPaymentMethods, Optional<Money> appFeeMoney, Optional<ShippingFee> shippingFee, Optional<Boolean> enableCoupon, Optional<Boolean> enableLoyalty, Map<String, Object> additionalProperties) {
        this.allowTipping = allowTipping;
        this.customFields = customFields;
        this.subscriptionPlanId = subscriptionPlanId;
        this.redirectUrl = redirectUrl;
        this.merchantSupportEmail = merchantSupportEmail;
        this.askForShippingAddress = askForShippingAddress;
        this.acceptedPaymentMethods = acceptedPaymentMethods;
        this.appFeeMoney = appFeeMoney;
        this.shippingFee = shippingFee;
        this.enableCoupon = enableCoupon;
        this.enableLoyalty = enableLoyalty;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Boolean> getAllowTipping() {
        if (this.allowTipping == null) {
            return Optional.empty();
        }
        return this.allowTipping;
    }

    @JsonIgnore
    public Optional<List<CustomField>> getCustomFields() {
        if (this.customFields == null) {
            return Optional.empty();
        }
        return this.customFields;
    }

    @JsonIgnore
    public Optional<String> getSubscriptionPlanId() {
        if (this.subscriptionPlanId == null) {
            return Optional.empty();
        }
        return this.subscriptionPlanId;
    }

    @JsonIgnore
    public Optional<String> getRedirectUrl() {
        if (this.redirectUrl == null) {
            return Optional.empty();
        }
        return this.redirectUrl;
    }

    @JsonIgnore
    public Optional<String> getMerchantSupportEmail() {
        if (this.merchantSupportEmail == null) {
            return Optional.empty();
        }
        return this.merchantSupportEmail;
    }

    @JsonIgnore
    public Optional<Boolean> getAskForShippingAddress() {
        if (this.askForShippingAddress == null) {
            return Optional.empty();
        }
        return this.askForShippingAddress;
    }

    @JsonProperty(value="accepted_payment_methods")
    public Optional<AcceptedPaymentMethods> getAcceptedPaymentMethods() {
        return this.acceptedPaymentMethods;
    }

    @JsonProperty(value="app_fee_money")
    public Optional<Money> getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonProperty(value="shipping_fee")
    public Optional<ShippingFee> getShippingFee() {
        return this.shippingFee;
    }

    @JsonIgnore
    public Optional<Boolean> getEnableCoupon() {
        if (this.enableCoupon == null) {
            return Optional.empty();
        }
        return this.enableCoupon;
    }

    @JsonIgnore
    public Optional<Boolean> getEnableLoyalty() {
        if (this.enableLoyalty == null) {
            return Optional.empty();
        }
        return this.enableLoyalty;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="allow_tipping")
    private Optional<Boolean> _getAllowTipping() {
        return this.allowTipping;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="custom_fields")
    private Optional<List<CustomField>> _getCustomFields() {
        return this.customFields;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="subscription_plan_id")
    private Optional<String> _getSubscriptionPlanId() {
        return this.subscriptionPlanId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="redirect_url")
    private Optional<String> _getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="merchant_support_email")
    private Optional<String> _getMerchantSupportEmail() {
        return this.merchantSupportEmail;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ask_for_shipping_address")
    private Optional<Boolean> _getAskForShippingAddress() {
        return this.askForShippingAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="enable_coupon")
    private Optional<Boolean> _getEnableCoupon() {
        return this.enableCoupon;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="enable_loyalty")
    private Optional<Boolean> _getEnableLoyalty() {
        return this.enableLoyalty;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CheckoutOptions && this.equalTo((CheckoutOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckoutOptions other) {
        return this.allowTipping.equals(other.allowTipping) && this.customFields.equals(other.customFields) && this.subscriptionPlanId.equals(other.subscriptionPlanId) && this.redirectUrl.equals(other.redirectUrl) && this.merchantSupportEmail.equals(other.merchantSupportEmail) && this.askForShippingAddress.equals(other.askForShippingAddress) && this.acceptedPaymentMethods.equals(other.acceptedPaymentMethods) && this.appFeeMoney.equals(other.appFeeMoney) && this.shippingFee.equals(other.shippingFee) && this.enableCoupon.equals(other.enableCoupon) && this.enableLoyalty.equals(other.enableLoyalty);
    }

    public int hashCode() {
        return Objects.hash(this.allowTipping, this.customFields, this.subscriptionPlanId, this.redirectUrl, this.merchantSupportEmail, this.askForShippingAddress, this.acceptedPaymentMethods, this.appFeeMoney, this.shippingFee, this.enableCoupon, this.enableLoyalty);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> allowTipping = Optional.empty();
        private Optional<List<CustomField>> customFields = Optional.empty();
        private Optional<String> subscriptionPlanId = Optional.empty();
        private Optional<String> redirectUrl = Optional.empty();
        private Optional<String> merchantSupportEmail = Optional.empty();
        private Optional<Boolean> askForShippingAddress = Optional.empty();
        private Optional<AcceptedPaymentMethods> acceptedPaymentMethods = Optional.empty();
        private Optional<Money> appFeeMoney = Optional.empty();
        private Optional<ShippingFee> shippingFee = Optional.empty();
        private Optional<Boolean> enableCoupon = Optional.empty();
        private Optional<Boolean> enableLoyalty = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CheckoutOptions other) {
            this.allowTipping(other.getAllowTipping());
            this.customFields(other.getCustomFields());
            this.subscriptionPlanId(other.getSubscriptionPlanId());
            this.redirectUrl(other.getRedirectUrl());
            this.merchantSupportEmail(other.getMerchantSupportEmail());
            this.askForShippingAddress(other.getAskForShippingAddress());
            this.acceptedPaymentMethods(other.getAcceptedPaymentMethods());
            this.appFeeMoney(other.getAppFeeMoney());
            this.shippingFee(other.getShippingFee());
            this.enableCoupon(other.getEnableCoupon());
            this.enableLoyalty(other.getEnableLoyalty());
            return this;
        }

        @JsonSetter(value="allow_tipping", nulls=Nulls.SKIP)
        public Builder allowTipping(Optional<Boolean> allowTipping) {
            this.allowTipping = allowTipping;
            return this;
        }

        public Builder allowTipping(Boolean allowTipping) {
            this.allowTipping = Optional.ofNullable(allowTipping);
            return this;
        }

        public Builder allowTipping(Nullable<Boolean> allowTipping) {
            this.allowTipping = allowTipping.isNull() ? null : (allowTipping.isEmpty() ? Optional.empty() : Optional.of(allowTipping.get()));
            return this;
        }

        @JsonSetter(value="custom_fields", nulls=Nulls.SKIP)
        public Builder customFields(Optional<List<CustomField>> customFields) {
            this.customFields = customFields;
            return this;
        }

        public Builder customFields(List<CustomField> customFields) {
            this.customFields = Optional.ofNullable(customFields);
            return this;
        }

        public Builder customFields(Nullable<List<CustomField>> customFields) {
            this.customFields = customFields.isNull() ? null : (customFields.isEmpty() ? Optional.empty() : Optional.of(customFields.get()));
            return this;
        }

        @JsonSetter(value="subscription_plan_id", nulls=Nulls.SKIP)
        public Builder subscriptionPlanId(Optional<String> subscriptionPlanId) {
            this.subscriptionPlanId = subscriptionPlanId;
            return this;
        }

        public Builder subscriptionPlanId(String subscriptionPlanId) {
            this.subscriptionPlanId = Optional.ofNullable(subscriptionPlanId);
            return this;
        }

        public Builder subscriptionPlanId(Nullable<String> subscriptionPlanId) {
            this.subscriptionPlanId = subscriptionPlanId.isNull() ? null : (subscriptionPlanId.isEmpty() ? Optional.empty() : Optional.of(subscriptionPlanId.get()));
            return this;
        }

        @JsonSetter(value="redirect_url", nulls=Nulls.SKIP)
        public Builder redirectUrl(Optional<String> redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = Optional.ofNullable(redirectUrl);
            return this;
        }

        public Builder redirectUrl(Nullable<String> redirectUrl) {
            this.redirectUrl = redirectUrl.isNull() ? null : (redirectUrl.isEmpty() ? Optional.empty() : Optional.of(redirectUrl.get()));
            return this;
        }

        @JsonSetter(value="merchant_support_email", nulls=Nulls.SKIP)
        public Builder merchantSupportEmail(Optional<String> merchantSupportEmail) {
            this.merchantSupportEmail = merchantSupportEmail;
            return this;
        }

        public Builder merchantSupportEmail(String merchantSupportEmail) {
            this.merchantSupportEmail = Optional.ofNullable(merchantSupportEmail);
            return this;
        }

        public Builder merchantSupportEmail(Nullable<String> merchantSupportEmail) {
            this.merchantSupportEmail = merchantSupportEmail.isNull() ? null : (merchantSupportEmail.isEmpty() ? Optional.empty() : Optional.of(merchantSupportEmail.get()));
            return this;
        }

        @JsonSetter(value="ask_for_shipping_address", nulls=Nulls.SKIP)
        public Builder askForShippingAddress(Optional<Boolean> askForShippingAddress) {
            this.askForShippingAddress = askForShippingAddress;
            return this;
        }

        public Builder askForShippingAddress(Boolean askForShippingAddress) {
            this.askForShippingAddress = Optional.ofNullable(askForShippingAddress);
            return this;
        }

        public Builder askForShippingAddress(Nullable<Boolean> askForShippingAddress) {
            this.askForShippingAddress = askForShippingAddress.isNull() ? null : (askForShippingAddress.isEmpty() ? Optional.empty() : Optional.of(askForShippingAddress.get()));
            return this;
        }

        @JsonSetter(value="accepted_payment_methods", nulls=Nulls.SKIP)
        public Builder acceptedPaymentMethods(Optional<AcceptedPaymentMethods> acceptedPaymentMethods) {
            this.acceptedPaymentMethods = acceptedPaymentMethods;
            return this;
        }

        public Builder acceptedPaymentMethods(AcceptedPaymentMethods acceptedPaymentMethods) {
            this.acceptedPaymentMethods = Optional.ofNullable(acceptedPaymentMethods);
            return this;
        }

        @JsonSetter(value="app_fee_money", nulls=Nulls.SKIP)
        public Builder appFeeMoney(Optional<Money> appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        public Builder appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = Optional.ofNullable(appFeeMoney);
            return this;
        }

        @JsonSetter(value="shipping_fee", nulls=Nulls.SKIP)
        public Builder shippingFee(Optional<ShippingFee> shippingFee) {
            this.shippingFee = shippingFee;
            return this;
        }

        public Builder shippingFee(ShippingFee shippingFee) {
            this.shippingFee = Optional.ofNullable(shippingFee);
            return this;
        }

        @JsonSetter(value="enable_coupon", nulls=Nulls.SKIP)
        public Builder enableCoupon(Optional<Boolean> enableCoupon) {
            this.enableCoupon = enableCoupon;
            return this;
        }

        public Builder enableCoupon(Boolean enableCoupon) {
            this.enableCoupon = Optional.ofNullable(enableCoupon);
            return this;
        }

        public Builder enableCoupon(Nullable<Boolean> enableCoupon) {
            this.enableCoupon = enableCoupon.isNull() ? null : (enableCoupon.isEmpty() ? Optional.empty() : Optional.of(enableCoupon.get()));
            return this;
        }

        @JsonSetter(value="enable_loyalty", nulls=Nulls.SKIP)
        public Builder enableLoyalty(Optional<Boolean> enableLoyalty) {
            this.enableLoyalty = enableLoyalty;
            return this;
        }

        public Builder enableLoyalty(Boolean enableLoyalty) {
            this.enableLoyalty = Optional.ofNullable(enableLoyalty);
            return this;
        }

        public Builder enableLoyalty(Nullable<Boolean> enableLoyalty) {
            this.enableLoyalty = enableLoyalty.isNull() ? null : (enableLoyalty.isEmpty() ? Optional.empty() : Optional.of(enableLoyalty.get()));
            return this;
        }

        public CheckoutOptions build() {
            return new CheckoutOptions(this.allowTipping, this.customFields, this.subscriptionPlanId, this.redirectUrl, this.merchantSupportEmail, this.askForShippingAddress, this.acceptedPaymentMethods, this.appFeeMoney, this.shippingFee, this.enableCoupon, this.enableLoyalty, this.additionalProperties);
        }
    }
}

