/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogV1Id {
    private final Optional<String> catalogV1Id;
    private final Optional<String> locationId;
    private final Map<String, Object> additionalProperties;

    private CatalogV1Id(Optional<String> catalogV1Id, Optional<String> locationId, Map<String, Object> additionalProperties) {
        this.catalogV1Id = catalogV1Id;
        this.locationId = locationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getCatalogV1Id() {
        if (this.catalogV1Id == null) {
            return Optional.empty();
        }
        return this.catalogV1Id;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_v1_id")
    private Optional<String> _getCatalogV1Id() {
        return this.catalogV1Id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogV1Id && this.equalTo((CatalogV1Id)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogV1Id other) {
        return this.catalogV1Id.equals(other.catalogV1Id) && this.locationId.equals(other.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.catalogV1Id, this.locationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> catalogV1Id = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogV1Id other) {
            this.catalogV1Id(other.getCatalogV1Id());
            this.locationId(other.getLocationId());
            return this;
        }

        @JsonSetter(value="catalog_v1_id", nulls=Nulls.SKIP)
        public Builder catalogV1Id(Optional<String> catalogV1Id) {
            this.catalogV1Id = catalogV1Id;
            return this;
        }

        public Builder catalogV1Id(String catalogV1Id) {
            this.catalogV1Id = Optional.ofNullable(catalogV1Id);
            return this;
        }

        public Builder catalogV1Id(Nullable<String> catalogV1Id) {
            this.catalogV1Id = catalogV1Id.isNull() ? null : (catalogV1Id.isEmpty() ? Optional.empty() : Optional.of(catalogV1Id.get()));
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        public CatalogV1Id build() {
            return new CatalogV1Id(this.catalogV1Id, this.locationId, this.additionalProperties);
        }
    }
}

