/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogTimePeriod {
    private final Optional<String> event;
    private final Map<String, Object> additionalProperties;

    private CatalogTimePeriod(Optional<String> event, Map<String, Object> additionalProperties) {
        this.event = event;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getEvent() {
        if (this.event == null) {
            return Optional.empty();
        }
        return this.event;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="event")
    private Optional<String> _getEvent() {
        return this.event;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogTimePeriod && this.equalTo((CatalogTimePeriod)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogTimePeriod other) {
        return this.event.equals(other.event);
    }

    public int hashCode() {
        return Objects.hash(this.event);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> event = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogTimePeriod other) {
            this.event(other.getEvent());
            return this;
        }

        @JsonSetter(value="event", nulls=Nulls.SKIP)
        public Builder event(Optional<String> event) {
            this.event = event;
            return this;
        }

        public Builder event(String event) {
            this.event = Optional.ofNullable(event);
            return this;
        }

        public Builder event(Nullable<String> event) {
            this.event = event.isNull() ? null : (event.isEmpty() ? Optional.empty() : Optional.of(event.get()));
            return this;
        }

        public CatalogTimePeriod build() {
            return new CatalogTimePeriod(this.event, this.additionalProperties);
        }
    }
}

