/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TaxCalculationPhase;
import com.squareup.square.types.TaxInclusionType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogTax {
    private final Optional<String> name;
    private final Optional<TaxCalculationPhase> calculationPhase;
    private final Optional<TaxInclusionType> inclusionType;
    private final Optional<String> percentage;
    private final Optional<Boolean> appliesToCustomAmounts;
    private final Optional<Boolean> enabled;
    private final Optional<String> appliesToProductSetId;
    private final Map<String, Object> additionalProperties;

    private CatalogTax(Optional<String> name, Optional<TaxCalculationPhase> calculationPhase, Optional<TaxInclusionType> inclusionType, Optional<String> percentage, Optional<Boolean> appliesToCustomAmounts, Optional<Boolean> enabled, Optional<String> appliesToProductSetId, Map<String, Object> additionalProperties) {
        this.name = name;
        this.calculationPhase = calculationPhase;
        this.inclusionType = inclusionType;
        this.percentage = percentage;
        this.appliesToCustomAmounts = appliesToCustomAmounts;
        this.enabled = enabled;
        this.appliesToProductSetId = appliesToProductSetId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="calculation_phase")
    public Optional<TaxCalculationPhase> getCalculationPhase() {
        return this.calculationPhase;
    }

    @JsonProperty(value="inclusion_type")
    public Optional<TaxInclusionType> getInclusionType() {
        return this.inclusionType;
    }

    @JsonIgnore
    public Optional<String> getPercentage() {
        if (this.percentage == null) {
            return Optional.empty();
        }
        return this.percentage;
    }

    @JsonIgnore
    public Optional<Boolean> getAppliesToCustomAmounts() {
        if (this.appliesToCustomAmounts == null) {
            return Optional.empty();
        }
        return this.appliesToCustomAmounts;
    }

    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        if (this.enabled == null) {
            return Optional.empty();
        }
        return this.enabled;
    }

    @JsonIgnore
    public Optional<String> getAppliesToProductSetId() {
        if (this.appliesToProductSetId == null) {
            return Optional.empty();
        }
        return this.appliesToProductSetId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="percentage")
    private Optional<String> _getPercentage() {
        return this.percentage;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="applies_to_custom_amounts")
    private Optional<Boolean> _getAppliesToCustomAmounts() {
        return this.appliesToCustomAmounts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="enabled")
    private Optional<Boolean> _getEnabled() {
        return this.enabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="applies_to_product_set_id")
    private Optional<String> _getAppliesToProductSetId() {
        return this.appliesToProductSetId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogTax && this.equalTo((CatalogTax)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogTax other) {
        return this.name.equals(other.name) && this.calculationPhase.equals(other.calculationPhase) && this.inclusionType.equals(other.inclusionType) && this.percentage.equals(other.percentage) && this.appliesToCustomAmounts.equals(other.appliesToCustomAmounts) && this.enabled.equals(other.enabled) && this.appliesToProductSetId.equals(other.appliesToProductSetId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.calculationPhase, this.inclusionType, this.percentage, this.appliesToCustomAmounts, this.enabled, this.appliesToProductSetId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<TaxCalculationPhase> calculationPhase = Optional.empty();
        private Optional<TaxInclusionType> inclusionType = Optional.empty();
        private Optional<String> percentage = Optional.empty();
        private Optional<Boolean> appliesToCustomAmounts = Optional.empty();
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<String> appliesToProductSetId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogTax other) {
            this.name(other.getName());
            this.calculationPhase(other.getCalculationPhase());
            this.inclusionType(other.getInclusionType());
            this.percentage(other.getPercentage());
            this.appliesToCustomAmounts(other.getAppliesToCustomAmounts());
            this.enabled(other.getEnabled());
            this.appliesToProductSetId(other.getAppliesToProductSetId());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="calculation_phase", nulls=Nulls.SKIP)
        public Builder calculationPhase(Optional<TaxCalculationPhase> calculationPhase) {
            this.calculationPhase = calculationPhase;
            return this;
        }

        public Builder calculationPhase(TaxCalculationPhase calculationPhase) {
            this.calculationPhase = Optional.ofNullable(calculationPhase);
            return this;
        }

        @JsonSetter(value="inclusion_type", nulls=Nulls.SKIP)
        public Builder inclusionType(Optional<TaxInclusionType> inclusionType) {
            this.inclusionType = inclusionType;
            return this;
        }

        public Builder inclusionType(TaxInclusionType inclusionType) {
            this.inclusionType = Optional.ofNullable(inclusionType);
            return this;
        }

        @JsonSetter(value="percentage", nulls=Nulls.SKIP)
        public Builder percentage(Optional<String> percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = Optional.ofNullable(percentage);
            return this;
        }

        public Builder percentage(Nullable<String> percentage) {
            this.percentage = percentage.isNull() ? null : (percentage.isEmpty() ? Optional.empty() : Optional.of(percentage.get()));
            return this;
        }

        @JsonSetter(value="applies_to_custom_amounts", nulls=Nulls.SKIP)
        public Builder appliesToCustomAmounts(Optional<Boolean> appliesToCustomAmounts) {
            this.appliesToCustomAmounts = appliesToCustomAmounts;
            return this;
        }

        public Builder appliesToCustomAmounts(Boolean appliesToCustomAmounts) {
            this.appliesToCustomAmounts = Optional.ofNullable(appliesToCustomAmounts);
            return this;
        }

        public Builder appliesToCustomAmounts(Nullable<Boolean> appliesToCustomAmounts) {
            this.appliesToCustomAmounts = appliesToCustomAmounts.isNull() ? null : (appliesToCustomAmounts.isEmpty() ? Optional.empty() : Optional.of(appliesToCustomAmounts.get()));
            return this;
        }

        @JsonSetter(value="enabled", nulls=Nulls.SKIP)
        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = Optional.ofNullable(enabled);
            return this;
        }

        public Builder enabled(Nullable<Boolean> enabled) {
            this.enabled = enabled.isNull() ? null : (enabled.isEmpty() ? Optional.empty() : Optional.of(enabled.get()));
            return this;
        }

        @JsonSetter(value="applies_to_product_set_id", nulls=Nulls.SKIP)
        public Builder appliesToProductSetId(Optional<String> appliesToProductSetId) {
            this.appliesToProductSetId = appliesToProductSetId;
            return this;
        }

        public Builder appliesToProductSetId(String appliesToProductSetId) {
            this.appliesToProductSetId = Optional.ofNullable(appliesToProductSetId);
            return this;
        }

        public Builder appliesToProductSetId(Nullable<String> appliesToProductSetId) {
            this.appliesToProductSetId = appliesToProductSetId.isNull() ? null : (appliesToProductSetId.isEmpty() ? Optional.empty() : Optional.of(appliesToProductSetId.get()));
            return this;
        }

        public CatalogTax build() {
            return new CatalogTax(this.name, this.calculationPhase, this.inclusionType, this.percentage, this.appliesToCustomAmounts, this.enabled, this.appliesToProductSetId, this.additionalProperties);
        }
    }
}

