/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogQuerySet {
    private final String attributeName;
    private final List<String> attributeValues;
    private final Map<String, Object> additionalProperties;

    private CatalogQuerySet(String attributeName, List<String> attributeValues, Map<String, Object> additionalProperties) {
        this.attributeName = attributeName;
        this.attributeValues = attributeValues;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="attribute_name")
    public String getAttributeName() {
        return this.attributeName;
    }

    @JsonProperty(value="attribute_values")
    public List<String> getAttributeValues() {
        return this.attributeValues;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogQuerySet && this.equalTo((CatalogQuerySet)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogQuerySet other) {
        return this.attributeName.equals(other.attributeName) && this.attributeValues.equals(other.attributeValues);
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.attributeValues);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AttributeNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AttributeNameStage,
    _FinalStage {
        private String attributeName;
        private List<String> attributeValues = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogQuerySet other) {
            this.attributeName(other.getAttributeName());
            this.attributeValues(other.getAttributeValues());
            return this;
        }

        @Override
        @JsonSetter(value="attribute_name")
        public _FinalStage attributeName(@NotNull String attributeName) {
            this.attributeName = Objects.requireNonNull(attributeName, "attributeName must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllAttributeValues(List<String> attributeValues) {
            this.attributeValues.addAll(attributeValues);
            return this;
        }

        @Override
        public _FinalStage addAttributeValues(String attributeValues) {
            this.attributeValues.add(attributeValues);
            return this;
        }

        @Override
        @JsonSetter(value="attribute_values", nulls=Nulls.SKIP)
        public _FinalStage attributeValues(List<String> attributeValues) {
            this.attributeValues.clear();
            this.attributeValues.addAll(attributeValues);
            return this;
        }

        @Override
        public CatalogQuerySet build() {
            return new CatalogQuerySet(this.attributeName, this.attributeValues, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogQuerySet build();

        public _FinalStage attributeValues(List<String> var1);

        public _FinalStage addAttributeValues(String var1);

        public _FinalStage addAllAttributeValues(List<String> var1);
    }

    public static interface AttributeNameStage {
        public _FinalStage attributeName(@NotNull String var1);

        public Builder from(CatalogQuerySet var1);
    }
}

