/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogQueryRange {
    private final String attributeName;
    private final Optional<Long> attributeMinValue;
    private final Optional<Long> attributeMaxValue;
    private final Map<String, Object> additionalProperties;

    private CatalogQueryRange(String attributeName, Optional<Long> attributeMinValue, Optional<Long> attributeMaxValue, Map<String, Object> additionalProperties) {
        this.attributeName = attributeName;
        this.attributeMinValue = attributeMinValue;
        this.attributeMaxValue = attributeMaxValue;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="attribute_name")
    public String getAttributeName() {
        return this.attributeName;
    }

    @JsonIgnore
    public Optional<Long> getAttributeMinValue() {
        if (this.attributeMinValue == null) {
            return Optional.empty();
        }
        return this.attributeMinValue;
    }

    @JsonIgnore
    public Optional<Long> getAttributeMaxValue() {
        if (this.attributeMaxValue == null) {
            return Optional.empty();
        }
        return this.attributeMaxValue;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="attribute_min_value")
    private Optional<Long> _getAttributeMinValue() {
        return this.attributeMinValue;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="attribute_max_value")
    private Optional<Long> _getAttributeMaxValue() {
        return this.attributeMaxValue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogQueryRange && this.equalTo((CatalogQueryRange)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogQueryRange other) {
        return this.attributeName.equals(other.attributeName) && this.attributeMinValue.equals(other.attributeMinValue) && this.attributeMaxValue.equals(other.attributeMaxValue);
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.attributeMinValue, this.attributeMaxValue);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AttributeNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AttributeNameStage,
    _FinalStage {
        private String attributeName;
        private Optional<Long> attributeMaxValue = Optional.empty();
        private Optional<Long> attributeMinValue = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogQueryRange other) {
            this.attributeName(other.getAttributeName());
            this.attributeMinValue(other.getAttributeMinValue());
            this.attributeMaxValue(other.getAttributeMaxValue());
            return this;
        }

        @Override
        @JsonSetter(value="attribute_name")
        public _FinalStage attributeName(@NotNull String attributeName) {
            this.attributeName = Objects.requireNonNull(attributeName, "attributeName must not be null");
            return this;
        }

        @Override
        public _FinalStage attributeMaxValue(Nullable<Long> attributeMaxValue) {
            this.attributeMaxValue = attributeMaxValue.isNull() ? null : (attributeMaxValue.isEmpty() ? Optional.empty() : Optional.of(attributeMaxValue.get()));
            return this;
        }

        @Override
        public _FinalStage attributeMaxValue(Long attributeMaxValue) {
            this.attributeMaxValue = Optional.ofNullable(attributeMaxValue);
            return this;
        }

        @Override
        @JsonSetter(value="attribute_max_value", nulls=Nulls.SKIP)
        public _FinalStage attributeMaxValue(Optional<Long> attributeMaxValue) {
            this.attributeMaxValue = attributeMaxValue;
            return this;
        }

        @Override
        public _FinalStage attributeMinValue(Nullable<Long> attributeMinValue) {
            this.attributeMinValue = attributeMinValue.isNull() ? null : (attributeMinValue.isEmpty() ? Optional.empty() : Optional.of(attributeMinValue.get()));
            return this;
        }

        @Override
        public _FinalStage attributeMinValue(Long attributeMinValue) {
            this.attributeMinValue = Optional.ofNullable(attributeMinValue);
            return this;
        }

        @Override
        @JsonSetter(value="attribute_min_value", nulls=Nulls.SKIP)
        public _FinalStage attributeMinValue(Optional<Long> attributeMinValue) {
            this.attributeMinValue = attributeMinValue;
            return this;
        }

        @Override
        public CatalogQueryRange build() {
            return new CatalogQueryRange(this.attributeName, this.attributeMinValue, this.attributeMaxValue, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogQueryRange build();

        public _FinalStage attributeMinValue(Optional<Long> var1);

        public _FinalStage attributeMinValue(Long var1);

        public _FinalStage attributeMinValue(Nullable<Long> var1);

        public _FinalStage attributeMaxValue(Optional<Long> var1);

        public _FinalStage attributeMaxValue(Long var1);

        public _FinalStage attributeMaxValue(Nullable<Long> var1);
    }

    public static interface AttributeNameStage {
        public _FinalStage attributeName(@NotNull String var1);

        public Builder from(CatalogQueryRange var1);
    }
}

