/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogProductSet {
    private final Optional<String> name;
    private final Optional<List<String>> productIdsAny;
    private final Optional<List<String>> productIdsAll;
    private final Optional<Long> quantityExact;
    private final Optional<Long> quantityMin;
    private final Optional<Long> quantityMax;
    private final Optional<Boolean> allProducts;
    private final Map<String, Object> additionalProperties;

    private CatalogProductSet(Optional<String> name, Optional<List<String>> productIdsAny, Optional<List<String>> productIdsAll, Optional<Long> quantityExact, Optional<Long> quantityMin, Optional<Long> quantityMax, Optional<Boolean> allProducts, Map<String, Object> additionalProperties) {
        this.name = name;
        this.productIdsAny = productIdsAny;
        this.productIdsAll = productIdsAll;
        this.quantityExact = quantityExact;
        this.quantityMin = quantityMin;
        this.quantityMax = quantityMax;
        this.allProducts = allProducts;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<List<String>> getProductIdsAny() {
        if (this.productIdsAny == null) {
            return Optional.empty();
        }
        return this.productIdsAny;
    }

    @JsonIgnore
    public Optional<List<String>> getProductIdsAll() {
        if (this.productIdsAll == null) {
            return Optional.empty();
        }
        return this.productIdsAll;
    }

    @JsonIgnore
    public Optional<Long> getQuantityExact() {
        if (this.quantityExact == null) {
            return Optional.empty();
        }
        return this.quantityExact;
    }

    @JsonIgnore
    public Optional<Long> getQuantityMin() {
        if (this.quantityMin == null) {
            return Optional.empty();
        }
        return this.quantityMin;
    }

    @JsonIgnore
    public Optional<Long> getQuantityMax() {
        if (this.quantityMax == null) {
            return Optional.empty();
        }
        return this.quantityMax;
    }

    @JsonIgnore
    public Optional<Boolean> getAllProducts() {
        if (this.allProducts == null) {
            return Optional.empty();
        }
        return this.allProducts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="product_ids_any")
    private Optional<List<String>> _getProductIdsAny() {
        return this.productIdsAny;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="product_ids_all")
    private Optional<List<String>> _getProductIdsAll() {
        return this.productIdsAll;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="quantity_exact")
    private Optional<Long> _getQuantityExact() {
        return this.quantityExact;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="quantity_min")
    private Optional<Long> _getQuantityMin() {
        return this.quantityMin;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="quantity_max")
    private Optional<Long> _getQuantityMax() {
        return this.quantityMax;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="all_products")
    private Optional<Boolean> _getAllProducts() {
        return this.allProducts;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogProductSet && this.equalTo((CatalogProductSet)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogProductSet other) {
        return this.name.equals(other.name) && this.productIdsAny.equals(other.productIdsAny) && this.productIdsAll.equals(other.productIdsAll) && this.quantityExact.equals(other.quantityExact) && this.quantityMin.equals(other.quantityMin) && this.quantityMax.equals(other.quantityMax) && this.allProducts.equals(other.allProducts);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.productIdsAny, this.productIdsAll, this.quantityExact, this.quantityMin, this.quantityMax, this.allProducts);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<List<String>> productIdsAny = Optional.empty();
        private Optional<List<String>> productIdsAll = Optional.empty();
        private Optional<Long> quantityExact = Optional.empty();
        private Optional<Long> quantityMin = Optional.empty();
        private Optional<Long> quantityMax = Optional.empty();
        private Optional<Boolean> allProducts = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogProductSet other) {
            this.name(other.getName());
            this.productIdsAny(other.getProductIdsAny());
            this.productIdsAll(other.getProductIdsAll());
            this.quantityExact(other.getQuantityExact());
            this.quantityMin(other.getQuantityMin());
            this.quantityMax(other.getQuantityMax());
            this.allProducts(other.getAllProducts());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="product_ids_any", nulls=Nulls.SKIP)
        public Builder productIdsAny(Optional<List<String>> productIdsAny) {
            this.productIdsAny = productIdsAny;
            return this;
        }

        public Builder productIdsAny(List<String> productIdsAny) {
            this.productIdsAny = Optional.ofNullable(productIdsAny);
            return this;
        }

        public Builder productIdsAny(Nullable<List<String>> productIdsAny) {
            this.productIdsAny = productIdsAny.isNull() ? null : (productIdsAny.isEmpty() ? Optional.empty() : Optional.of(productIdsAny.get()));
            return this;
        }

        @JsonSetter(value="product_ids_all", nulls=Nulls.SKIP)
        public Builder productIdsAll(Optional<List<String>> productIdsAll) {
            this.productIdsAll = productIdsAll;
            return this;
        }

        public Builder productIdsAll(List<String> productIdsAll) {
            this.productIdsAll = Optional.ofNullable(productIdsAll);
            return this;
        }

        public Builder productIdsAll(Nullable<List<String>> productIdsAll) {
            this.productIdsAll = productIdsAll.isNull() ? null : (productIdsAll.isEmpty() ? Optional.empty() : Optional.of(productIdsAll.get()));
            return this;
        }

        @JsonSetter(value="quantity_exact", nulls=Nulls.SKIP)
        public Builder quantityExact(Optional<Long> quantityExact) {
            this.quantityExact = quantityExact;
            return this;
        }

        public Builder quantityExact(Long quantityExact) {
            this.quantityExact = Optional.ofNullable(quantityExact);
            return this;
        }

        public Builder quantityExact(Nullable<Long> quantityExact) {
            this.quantityExact = quantityExact.isNull() ? null : (quantityExact.isEmpty() ? Optional.empty() : Optional.of(quantityExact.get()));
            return this;
        }

        @JsonSetter(value="quantity_min", nulls=Nulls.SKIP)
        public Builder quantityMin(Optional<Long> quantityMin) {
            this.quantityMin = quantityMin;
            return this;
        }

        public Builder quantityMin(Long quantityMin) {
            this.quantityMin = Optional.ofNullable(quantityMin);
            return this;
        }

        public Builder quantityMin(Nullable<Long> quantityMin) {
            this.quantityMin = quantityMin.isNull() ? null : (quantityMin.isEmpty() ? Optional.empty() : Optional.of(quantityMin.get()));
            return this;
        }

        @JsonSetter(value="quantity_max", nulls=Nulls.SKIP)
        public Builder quantityMax(Optional<Long> quantityMax) {
            this.quantityMax = quantityMax;
            return this;
        }

        public Builder quantityMax(Long quantityMax) {
            this.quantityMax = Optional.ofNullable(quantityMax);
            return this;
        }

        public Builder quantityMax(Nullable<Long> quantityMax) {
            this.quantityMax = quantityMax.isNull() ? null : (quantityMax.isEmpty() ? Optional.empty() : Optional.of(quantityMax.get()));
            return this;
        }

        @JsonSetter(value="all_products", nulls=Nulls.SKIP)
        public Builder allProducts(Optional<Boolean> allProducts) {
            this.allProducts = allProducts;
            return this;
        }

        public Builder allProducts(Boolean allProducts) {
            this.allProducts = Optional.ofNullable(allProducts);
            return this;
        }

        public Builder allProducts(Nullable<Boolean> allProducts) {
            this.allProducts = allProducts.isNull() ? null : (allProducts.isEmpty() ? Optional.empty() : Optional.of(allProducts.get()));
            return this;
        }

        public CatalogProductSet build() {
            return new CatalogProductSet(this.name, this.productIdsAny, this.productIdsAll, this.quantityExact, this.quantityMin, this.quantityMax, this.allProducts, this.additionalProperties);
        }
    }
}

