/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ExcludeStrategy;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogPricingRule {
    private final Optional<String> name;
    private final Optional<List<String>> timePeriodIds;
    private final Optional<String> discountId;
    private final Optional<String> matchProductsId;
    private final Optional<String> applyProductsId;
    private final Optional<String> excludeProductsId;
    private final Optional<String> validFromDate;
    private final Optional<String> validFromLocalTime;
    private final Optional<String> validUntilDate;
    private final Optional<String> validUntilLocalTime;
    private final Optional<ExcludeStrategy> excludeStrategy;
    private final Optional<Money> minimumOrderSubtotalMoney;
    private final Optional<List<String>> customerGroupIdsAny;
    private final Map<String, Object> additionalProperties;

    private CatalogPricingRule(Optional<String> name, Optional<List<String>> timePeriodIds, Optional<String> discountId, Optional<String> matchProductsId, Optional<String> applyProductsId, Optional<String> excludeProductsId, Optional<String> validFromDate, Optional<String> validFromLocalTime, Optional<String> validUntilDate, Optional<String> validUntilLocalTime, Optional<ExcludeStrategy> excludeStrategy, Optional<Money> minimumOrderSubtotalMoney, Optional<List<String>> customerGroupIdsAny, Map<String, Object> additionalProperties) {
        this.name = name;
        this.timePeriodIds = timePeriodIds;
        this.discountId = discountId;
        this.matchProductsId = matchProductsId;
        this.applyProductsId = applyProductsId;
        this.excludeProductsId = excludeProductsId;
        this.validFromDate = validFromDate;
        this.validFromLocalTime = validFromLocalTime;
        this.validUntilDate = validUntilDate;
        this.validUntilLocalTime = validUntilLocalTime;
        this.excludeStrategy = excludeStrategy;
        this.minimumOrderSubtotalMoney = minimumOrderSubtotalMoney;
        this.customerGroupIdsAny = customerGroupIdsAny;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<List<String>> getTimePeriodIds() {
        if (this.timePeriodIds == null) {
            return Optional.empty();
        }
        return this.timePeriodIds;
    }

    @JsonIgnore
    public Optional<String> getDiscountId() {
        if (this.discountId == null) {
            return Optional.empty();
        }
        return this.discountId;
    }

    @JsonIgnore
    public Optional<String> getMatchProductsId() {
        if (this.matchProductsId == null) {
            return Optional.empty();
        }
        return this.matchProductsId;
    }

    @JsonIgnore
    public Optional<String> getApplyProductsId() {
        if (this.applyProductsId == null) {
            return Optional.empty();
        }
        return this.applyProductsId;
    }

    @JsonIgnore
    public Optional<String> getExcludeProductsId() {
        if (this.excludeProductsId == null) {
            return Optional.empty();
        }
        return this.excludeProductsId;
    }

    @JsonIgnore
    public Optional<String> getValidFromDate() {
        if (this.validFromDate == null) {
            return Optional.empty();
        }
        return this.validFromDate;
    }

    @JsonIgnore
    public Optional<String> getValidFromLocalTime() {
        if (this.validFromLocalTime == null) {
            return Optional.empty();
        }
        return this.validFromLocalTime;
    }

    @JsonIgnore
    public Optional<String> getValidUntilDate() {
        if (this.validUntilDate == null) {
            return Optional.empty();
        }
        return this.validUntilDate;
    }

    @JsonIgnore
    public Optional<String> getValidUntilLocalTime() {
        if (this.validUntilLocalTime == null) {
            return Optional.empty();
        }
        return this.validUntilLocalTime;
    }

    @JsonProperty(value="exclude_strategy")
    public Optional<ExcludeStrategy> getExcludeStrategy() {
        return this.excludeStrategy;
    }

    @JsonProperty(value="minimum_order_subtotal_money")
    public Optional<Money> getMinimumOrderSubtotalMoney() {
        return this.minimumOrderSubtotalMoney;
    }

    @JsonIgnore
    public Optional<List<String>> getCustomerGroupIdsAny() {
        if (this.customerGroupIdsAny == null) {
            return Optional.empty();
        }
        return this.customerGroupIdsAny;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="time_period_ids")
    private Optional<List<String>> _getTimePeriodIds() {
        return this.timePeriodIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="discount_id")
    private Optional<String> _getDiscountId() {
        return this.discountId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="match_products_id")
    private Optional<String> _getMatchProductsId() {
        return this.matchProductsId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="apply_products_id")
    private Optional<String> _getApplyProductsId() {
        return this.applyProductsId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="exclude_products_id")
    private Optional<String> _getExcludeProductsId() {
        return this.excludeProductsId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="valid_from_date")
    private Optional<String> _getValidFromDate() {
        return this.validFromDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="valid_from_local_time")
    private Optional<String> _getValidFromLocalTime() {
        return this.validFromLocalTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="valid_until_date")
    private Optional<String> _getValidUntilDate() {
        return this.validUntilDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="valid_until_local_time")
    private Optional<String> _getValidUntilLocalTime() {
        return this.validUntilLocalTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_group_ids_any")
    private Optional<List<String>> _getCustomerGroupIdsAny() {
        return this.customerGroupIdsAny;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogPricingRule && this.equalTo((CatalogPricingRule)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogPricingRule other) {
        return this.name.equals(other.name) && this.timePeriodIds.equals(other.timePeriodIds) && this.discountId.equals(other.discountId) && this.matchProductsId.equals(other.matchProductsId) && this.applyProductsId.equals(other.applyProductsId) && this.excludeProductsId.equals(other.excludeProductsId) && this.validFromDate.equals(other.validFromDate) && this.validFromLocalTime.equals(other.validFromLocalTime) && this.validUntilDate.equals(other.validUntilDate) && this.validUntilLocalTime.equals(other.validUntilLocalTime) && this.excludeStrategy.equals(other.excludeStrategy) && this.minimumOrderSubtotalMoney.equals(other.minimumOrderSubtotalMoney) && this.customerGroupIdsAny.equals(other.customerGroupIdsAny);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.timePeriodIds, this.discountId, this.matchProductsId, this.applyProductsId, this.excludeProductsId, this.validFromDate, this.validFromLocalTime, this.validUntilDate, this.validUntilLocalTime, this.excludeStrategy, this.minimumOrderSubtotalMoney, this.customerGroupIdsAny);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<List<String>> timePeriodIds = Optional.empty();
        private Optional<String> discountId = Optional.empty();
        private Optional<String> matchProductsId = Optional.empty();
        private Optional<String> applyProductsId = Optional.empty();
        private Optional<String> excludeProductsId = Optional.empty();
        private Optional<String> validFromDate = Optional.empty();
        private Optional<String> validFromLocalTime = Optional.empty();
        private Optional<String> validUntilDate = Optional.empty();
        private Optional<String> validUntilLocalTime = Optional.empty();
        private Optional<ExcludeStrategy> excludeStrategy = Optional.empty();
        private Optional<Money> minimumOrderSubtotalMoney = Optional.empty();
        private Optional<List<String>> customerGroupIdsAny = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogPricingRule other) {
            this.name(other.getName());
            this.timePeriodIds(other.getTimePeriodIds());
            this.discountId(other.getDiscountId());
            this.matchProductsId(other.getMatchProductsId());
            this.applyProductsId(other.getApplyProductsId());
            this.excludeProductsId(other.getExcludeProductsId());
            this.validFromDate(other.getValidFromDate());
            this.validFromLocalTime(other.getValidFromLocalTime());
            this.validUntilDate(other.getValidUntilDate());
            this.validUntilLocalTime(other.getValidUntilLocalTime());
            this.excludeStrategy(other.getExcludeStrategy());
            this.minimumOrderSubtotalMoney(other.getMinimumOrderSubtotalMoney());
            this.customerGroupIdsAny(other.getCustomerGroupIdsAny());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="time_period_ids", nulls=Nulls.SKIP)
        public Builder timePeriodIds(Optional<List<String>> timePeriodIds) {
            this.timePeriodIds = timePeriodIds;
            return this;
        }

        public Builder timePeriodIds(List<String> timePeriodIds) {
            this.timePeriodIds = Optional.ofNullable(timePeriodIds);
            return this;
        }

        public Builder timePeriodIds(Nullable<List<String>> timePeriodIds) {
            this.timePeriodIds = timePeriodIds.isNull() ? null : (timePeriodIds.isEmpty() ? Optional.empty() : Optional.of(timePeriodIds.get()));
            return this;
        }

        @JsonSetter(value="discount_id", nulls=Nulls.SKIP)
        public Builder discountId(Optional<String> discountId) {
            this.discountId = discountId;
            return this;
        }

        public Builder discountId(String discountId) {
            this.discountId = Optional.ofNullable(discountId);
            return this;
        }

        public Builder discountId(Nullable<String> discountId) {
            this.discountId = discountId.isNull() ? null : (discountId.isEmpty() ? Optional.empty() : Optional.of(discountId.get()));
            return this;
        }

        @JsonSetter(value="match_products_id", nulls=Nulls.SKIP)
        public Builder matchProductsId(Optional<String> matchProductsId) {
            this.matchProductsId = matchProductsId;
            return this;
        }

        public Builder matchProductsId(String matchProductsId) {
            this.matchProductsId = Optional.ofNullable(matchProductsId);
            return this;
        }

        public Builder matchProductsId(Nullable<String> matchProductsId) {
            this.matchProductsId = matchProductsId.isNull() ? null : (matchProductsId.isEmpty() ? Optional.empty() : Optional.of(matchProductsId.get()));
            return this;
        }

        @JsonSetter(value="apply_products_id", nulls=Nulls.SKIP)
        public Builder applyProductsId(Optional<String> applyProductsId) {
            this.applyProductsId = applyProductsId;
            return this;
        }

        public Builder applyProductsId(String applyProductsId) {
            this.applyProductsId = Optional.ofNullable(applyProductsId);
            return this;
        }

        public Builder applyProductsId(Nullable<String> applyProductsId) {
            this.applyProductsId = applyProductsId.isNull() ? null : (applyProductsId.isEmpty() ? Optional.empty() : Optional.of(applyProductsId.get()));
            return this;
        }

        @JsonSetter(value="exclude_products_id", nulls=Nulls.SKIP)
        public Builder excludeProductsId(Optional<String> excludeProductsId) {
            this.excludeProductsId = excludeProductsId;
            return this;
        }

        public Builder excludeProductsId(String excludeProductsId) {
            this.excludeProductsId = Optional.ofNullable(excludeProductsId);
            return this;
        }

        public Builder excludeProductsId(Nullable<String> excludeProductsId) {
            this.excludeProductsId = excludeProductsId.isNull() ? null : (excludeProductsId.isEmpty() ? Optional.empty() : Optional.of(excludeProductsId.get()));
            return this;
        }

        @JsonSetter(value="valid_from_date", nulls=Nulls.SKIP)
        public Builder validFromDate(Optional<String> validFromDate) {
            this.validFromDate = validFromDate;
            return this;
        }

        public Builder validFromDate(String validFromDate) {
            this.validFromDate = Optional.ofNullable(validFromDate);
            return this;
        }

        public Builder validFromDate(Nullable<String> validFromDate) {
            this.validFromDate = validFromDate.isNull() ? null : (validFromDate.isEmpty() ? Optional.empty() : Optional.of(validFromDate.get()));
            return this;
        }

        @JsonSetter(value="valid_from_local_time", nulls=Nulls.SKIP)
        public Builder validFromLocalTime(Optional<String> validFromLocalTime) {
            this.validFromLocalTime = validFromLocalTime;
            return this;
        }

        public Builder validFromLocalTime(String validFromLocalTime) {
            this.validFromLocalTime = Optional.ofNullable(validFromLocalTime);
            return this;
        }

        public Builder validFromLocalTime(Nullable<String> validFromLocalTime) {
            this.validFromLocalTime = validFromLocalTime.isNull() ? null : (validFromLocalTime.isEmpty() ? Optional.empty() : Optional.of(validFromLocalTime.get()));
            return this;
        }

        @JsonSetter(value="valid_until_date", nulls=Nulls.SKIP)
        public Builder validUntilDate(Optional<String> validUntilDate) {
            this.validUntilDate = validUntilDate;
            return this;
        }

        public Builder validUntilDate(String validUntilDate) {
            this.validUntilDate = Optional.ofNullable(validUntilDate);
            return this;
        }

        public Builder validUntilDate(Nullable<String> validUntilDate) {
            this.validUntilDate = validUntilDate.isNull() ? null : (validUntilDate.isEmpty() ? Optional.empty() : Optional.of(validUntilDate.get()));
            return this;
        }

        @JsonSetter(value="valid_until_local_time", nulls=Nulls.SKIP)
        public Builder validUntilLocalTime(Optional<String> validUntilLocalTime) {
            this.validUntilLocalTime = validUntilLocalTime;
            return this;
        }

        public Builder validUntilLocalTime(String validUntilLocalTime) {
            this.validUntilLocalTime = Optional.ofNullable(validUntilLocalTime);
            return this;
        }

        public Builder validUntilLocalTime(Nullable<String> validUntilLocalTime) {
            this.validUntilLocalTime = validUntilLocalTime.isNull() ? null : (validUntilLocalTime.isEmpty() ? Optional.empty() : Optional.of(validUntilLocalTime.get()));
            return this;
        }

        @JsonSetter(value="exclude_strategy", nulls=Nulls.SKIP)
        public Builder excludeStrategy(Optional<ExcludeStrategy> excludeStrategy) {
            this.excludeStrategy = excludeStrategy;
            return this;
        }

        public Builder excludeStrategy(ExcludeStrategy excludeStrategy) {
            this.excludeStrategy = Optional.ofNullable(excludeStrategy);
            return this;
        }

        @JsonSetter(value="minimum_order_subtotal_money", nulls=Nulls.SKIP)
        public Builder minimumOrderSubtotalMoney(Optional<Money> minimumOrderSubtotalMoney) {
            this.minimumOrderSubtotalMoney = minimumOrderSubtotalMoney;
            return this;
        }

        public Builder minimumOrderSubtotalMoney(Money minimumOrderSubtotalMoney) {
            this.minimumOrderSubtotalMoney = Optional.ofNullable(minimumOrderSubtotalMoney);
            return this;
        }

        @JsonSetter(value="customer_group_ids_any", nulls=Nulls.SKIP)
        public Builder customerGroupIdsAny(Optional<List<String>> customerGroupIdsAny) {
            this.customerGroupIdsAny = customerGroupIdsAny;
            return this;
        }

        public Builder customerGroupIdsAny(List<String> customerGroupIdsAny) {
            this.customerGroupIdsAny = Optional.ofNullable(customerGroupIdsAny);
            return this;
        }

        public Builder customerGroupIdsAny(Nullable<List<String>> customerGroupIdsAny) {
            this.customerGroupIdsAny = customerGroupIdsAny.isNull() ? null : (customerGroupIdsAny.isEmpty() ? Optional.empty() : Optional.of(customerGroupIdsAny.get()));
            return this;
        }

        public CatalogPricingRule build() {
            return new CatalogPricingRule(this.name, this.timePeriodIds, this.discountId, this.matchProductsId, this.applyProductsId, this.excludeProductsId, this.validFromDate, this.validFromLocalTime, this.validUntilDate, this.validUntilLocalTime, this.excludeStrategy, this.minimumOrderSubtotalMoney, this.customerGroupIdsAny, this.additionalProperties);
        }
    }
}

