/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.squareup.square.types.CatalogObjectAvailabilityPeriod;
import com.squareup.square.types.CatalogObjectCategory;
import com.squareup.square.types.CatalogObjectCustomAttributeDefinition;
import com.squareup.square.types.CatalogObjectDiscount;
import com.squareup.square.types.CatalogObjectImage;
import com.squareup.square.types.CatalogObjectItem;
import com.squareup.square.types.CatalogObjectItemOption;
import com.squareup.square.types.CatalogObjectItemOptionValue;
import com.squareup.square.types.CatalogObjectItemVariation;
import com.squareup.square.types.CatalogObjectMeasurementUnit;
import com.squareup.square.types.CatalogObjectModifier;
import com.squareup.square.types.CatalogObjectModifierList;
import com.squareup.square.types.CatalogObjectPricingRule;
import com.squareup.square.types.CatalogObjectProductSet;
import com.squareup.square.types.CatalogObjectQuickAmountsSettings;
import com.squareup.square.types.CatalogObjectSubscriptionPlan;
import com.squareup.square.types.CatalogObjectSubscriptionPlanVariation;
import com.squareup.square.types.CatalogObjectTax;
import com.squareup.square.types.CatalogObjectTimePeriod;
import java.util.Objects;
import java.util.Optional;

public final class CatalogObject {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private CatalogObject(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static CatalogObject item(CatalogObjectItem value) {
        return new CatalogObject(new ItemValue(value));
    }

    public static CatalogObject image(CatalogObjectImage value) {
        return new CatalogObject(new ImageValue(value));
    }

    public static CatalogObject category(CatalogObjectCategory value) {
        return new CatalogObject(new CategoryValue(value));
    }

    public static CatalogObject itemVariation(CatalogObjectItemVariation value) {
        return new CatalogObject(new ItemVariationValue(value));
    }

    public static CatalogObject tax(CatalogObjectTax value) {
        return new CatalogObject(new TaxValue(value));
    }

    public static CatalogObject discount(CatalogObjectDiscount value) {
        return new CatalogObject(new DiscountValue(value));
    }

    public static CatalogObject modifierList(CatalogObjectModifierList value) {
        return new CatalogObject(new ModifierListValue(value));
    }

    public static CatalogObject modifier(CatalogObjectModifier value) {
        return new CatalogObject(new ModifierValue(value));
    }

    public static CatalogObject pricingRule(CatalogObjectPricingRule value) {
        return new CatalogObject(new PricingRuleValue(value));
    }

    public static CatalogObject productSet(CatalogObjectProductSet value) {
        return new CatalogObject(new ProductSetValue(value));
    }

    public static CatalogObject timePeriod(CatalogObjectTimePeriod value) {
        return new CatalogObject(new TimePeriodValue(value));
    }

    public static CatalogObject measurementUnit(CatalogObjectMeasurementUnit value) {
        return new CatalogObject(new MeasurementUnitValue(value));
    }

    public static CatalogObject subscriptionPlanVariation(CatalogObjectSubscriptionPlanVariation value) {
        return new CatalogObject(new SubscriptionPlanVariationValue(value));
    }

    public static CatalogObject itemOption(CatalogObjectItemOption value) {
        return new CatalogObject(new ItemOptionValue(value));
    }

    public static CatalogObject itemOptionVal(CatalogObjectItemOptionValue value) {
        return new CatalogObject(new ItemOptionValValue(value));
    }

    public static CatalogObject customAttributeDefinition(CatalogObjectCustomAttributeDefinition value) {
        return new CatalogObject(new CustomAttributeDefinitionValue(value));
    }

    public static CatalogObject quickAmountsSettings(CatalogObjectQuickAmountsSettings value) {
        return new CatalogObject(new QuickAmountsSettingsValue(value));
    }

    public static CatalogObject subscriptionPlan(CatalogObjectSubscriptionPlan value) {
        return new CatalogObject(new SubscriptionPlanValue(value));
    }

    public static CatalogObject availabilityPeriod(CatalogObjectAvailabilityPeriod value) {
        return new CatalogObject(new AvailabilityPeriodValue(value));
    }

    public boolean isItem() {
        return this.value instanceof ItemValue;
    }

    public boolean isImage() {
        return this.value instanceof ImageValue;
    }

    public boolean isCategory() {
        return this.value instanceof CategoryValue;
    }

    public boolean isItemVariation() {
        return this.value instanceof ItemVariationValue;
    }

    public boolean isTax() {
        return this.value instanceof TaxValue;
    }

    public boolean isDiscount() {
        return this.value instanceof DiscountValue;
    }

    public boolean isModifierList() {
        return this.value instanceof ModifierListValue;
    }

    public boolean isModifier() {
        return this.value instanceof ModifierValue;
    }

    public boolean isPricingRule() {
        return this.value instanceof PricingRuleValue;
    }

    public boolean isProductSet() {
        return this.value instanceof ProductSetValue;
    }

    public boolean isTimePeriod() {
        return this.value instanceof TimePeriodValue;
    }

    public boolean isMeasurementUnit() {
        return this.value instanceof MeasurementUnitValue;
    }

    public boolean isSubscriptionPlanVariation() {
        return this.value instanceof SubscriptionPlanVariationValue;
    }

    public boolean isItemOption() {
        return this.value instanceof ItemOptionValue;
    }

    public boolean isItemOptionVal() {
        return this.value instanceof ItemOptionValValue;
    }

    public boolean isCustomAttributeDefinition() {
        return this.value instanceof CustomAttributeDefinitionValue;
    }

    public boolean isQuickAmountsSettings() {
        return this.value instanceof QuickAmountsSettingsValue;
    }

    public boolean isSubscriptionPlan() {
        return this.value instanceof SubscriptionPlanValue;
    }

    public boolean isAvailabilityPeriod() {
        return this.value instanceof AvailabilityPeriodValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<CatalogObjectItem> getItem() {
        if (this.isItem()) {
            return Optional.of(((ItemValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectImage> getImage() {
        if (this.isImage()) {
            return Optional.of(((ImageValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectCategory> getCategory() {
        if (this.isCategory()) {
            return Optional.of(((CategoryValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectItemVariation> getItemVariation() {
        if (this.isItemVariation()) {
            return Optional.of(((ItemVariationValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectTax> getTax() {
        if (this.isTax()) {
            return Optional.of(((TaxValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectDiscount> getDiscount() {
        if (this.isDiscount()) {
            return Optional.of(((DiscountValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectModifierList> getModifierList() {
        if (this.isModifierList()) {
            return Optional.of(((ModifierListValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectModifier> getModifier() {
        if (this.isModifier()) {
            return Optional.of(((ModifierValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectPricingRule> getPricingRule() {
        if (this.isPricingRule()) {
            return Optional.of(((PricingRuleValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectProductSet> getProductSet() {
        if (this.isProductSet()) {
            return Optional.of(((ProductSetValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectTimePeriod> getTimePeriod() {
        if (this.isTimePeriod()) {
            return Optional.of(((TimePeriodValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectMeasurementUnit> getMeasurementUnit() {
        if (this.isMeasurementUnit()) {
            return Optional.of(((MeasurementUnitValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectSubscriptionPlanVariation> getSubscriptionPlanVariation() {
        if (this.isSubscriptionPlanVariation()) {
            return Optional.of(((SubscriptionPlanVariationValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectItemOption> getItemOption() {
        if (this.isItemOption()) {
            return Optional.of(((ItemOptionValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectItemOptionValue> getItemOptionVal() {
        if (this.isItemOptionVal()) {
            return Optional.of(((ItemOptionValValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectCustomAttributeDefinition> getCustomAttributeDefinition() {
        if (this.isCustomAttributeDefinition()) {
            return Optional.of(((CustomAttributeDefinitionValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectQuickAmountsSettings> getQuickAmountsSettings() {
        if (this.isQuickAmountsSettings()) {
            return Optional.of(((QuickAmountsSettingsValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectSubscriptionPlan> getSubscriptionPlan() {
        if (this.isSubscriptionPlan()) {
            return Optional.of(((SubscriptionPlanValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CatalogObjectAvailabilityPeriod> getAvailabilityPeriod() {
        if (this.isAvailabilityPeriod()) {
            return Optional.of(((AvailabilityPeriodValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "CatalogObject{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="AVAILABILITY_PERIOD")
    @JsonIgnoreProperties(value={"type"})
    private static final class AvailabilityPeriodValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectAvailabilityPeriod value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private AvailabilityPeriodValue() {
        }

        private AvailabilityPeriodValue(CatalogObjectAvailabilityPeriod value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitAvailabilityPeriod(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof AvailabilityPeriodValue && this.equalTo((AvailabilityPeriodValue)other);
        }

        private boolean equalTo(AvailabilityPeriodValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="SUBSCRIPTION_PLAN")
    @JsonIgnoreProperties(value={"type"})
    private static final class SubscriptionPlanValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectSubscriptionPlan value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SubscriptionPlanValue() {
        }

        private SubscriptionPlanValue(CatalogObjectSubscriptionPlan value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSubscriptionPlan(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SubscriptionPlanValue && this.equalTo((SubscriptionPlanValue)other);
        }

        private boolean equalTo(SubscriptionPlanValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="QUICK_AMOUNTS_SETTINGS")
    @JsonIgnoreProperties(value={"type"})
    private static final class QuickAmountsSettingsValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectQuickAmountsSettings value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private QuickAmountsSettingsValue() {
        }

        private QuickAmountsSettingsValue(CatalogObjectQuickAmountsSettings value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitQuickAmountsSettings(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof QuickAmountsSettingsValue && this.equalTo((QuickAmountsSettingsValue)other);
        }

        private boolean equalTo(QuickAmountsSettingsValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="CUSTOM_ATTRIBUTE_DEFINITION")
    @JsonIgnoreProperties(value={"type"})
    private static final class CustomAttributeDefinitionValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectCustomAttributeDefinition value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private CustomAttributeDefinitionValue() {
        }

        private CustomAttributeDefinitionValue(CatalogObjectCustomAttributeDefinition value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitCustomAttributeDefinition(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CustomAttributeDefinitionValue && this.equalTo((CustomAttributeDefinitionValue)other);
        }

        private boolean equalTo(CustomAttributeDefinitionValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="ITEM_OPTION_VAL")
    @JsonIgnoreProperties(value={"type"})
    private static final class ItemOptionValValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectItemOptionValue value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ItemOptionValValue() {
        }

        private ItemOptionValValue(CatalogObjectItemOptionValue value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitItemOptionVal(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ItemOptionValValue && this.equalTo((ItemOptionValValue)other);
        }

        private boolean equalTo(ItemOptionValValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="ITEM_OPTION")
    @JsonIgnoreProperties(value={"type"})
    private static final class ItemOptionValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectItemOption value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ItemOptionValue() {
        }

        private ItemOptionValue(CatalogObjectItemOption value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitItemOption(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ItemOptionValue && this.equalTo((ItemOptionValue)other);
        }

        private boolean equalTo(ItemOptionValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="SUBSCRIPTION_PLAN_VARIATION")
    @JsonIgnoreProperties(value={"type"})
    private static final class SubscriptionPlanVariationValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectSubscriptionPlanVariation value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SubscriptionPlanVariationValue() {
        }

        private SubscriptionPlanVariationValue(CatalogObjectSubscriptionPlanVariation value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSubscriptionPlanVariation(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SubscriptionPlanVariationValue && this.equalTo((SubscriptionPlanVariationValue)other);
        }

        private boolean equalTo(SubscriptionPlanVariationValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="MEASUREMENT_UNIT")
    @JsonIgnoreProperties(value={"type"})
    private static final class MeasurementUnitValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectMeasurementUnit value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private MeasurementUnitValue() {
        }

        private MeasurementUnitValue(CatalogObjectMeasurementUnit value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitMeasurementUnit(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof MeasurementUnitValue && this.equalTo((MeasurementUnitValue)other);
        }

        private boolean equalTo(MeasurementUnitValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="TIME_PERIOD")
    @JsonIgnoreProperties(value={"type"})
    private static final class TimePeriodValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectTimePeriod value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TimePeriodValue() {
        }

        private TimePeriodValue(CatalogObjectTimePeriod value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitTimePeriod(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TimePeriodValue && this.equalTo((TimePeriodValue)other);
        }

        private boolean equalTo(TimePeriodValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="PRODUCT_SET")
    @JsonIgnoreProperties(value={"type"})
    private static final class ProductSetValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectProductSet value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ProductSetValue() {
        }

        private ProductSetValue(CatalogObjectProductSet value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitProductSet(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ProductSetValue && this.equalTo((ProductSetValue)other);
        }

        private boolean equalTo(ProductSetValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="PRICING_RULE")
    @JsonIgnoreProperties(value={"type"})
    private static final class PricingRuleValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectPricingRule value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private PricingRuleValue() {
        }

        private PricingRuleValue(CatalogObjectPricingRule value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitPricingRule(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof PricingRuleValue && this.equalTo((PricingRuleValue)other);
        }

        private boolean equalTo(PricingRuleValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="MODIFIER")
    @JsonIgnoreProperties(value={"type"})
    private static final class ModifierValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectModifier value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ModifierValue() {
        }

        private ModifierValue(CatalogObjectModifier value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitModifier(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ModifierValue && this.equalTo((ModifierValue)other);
        }

        private boolean equalTo(ModifierValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="MODIFIER_LIST")
    @JsonIgnoreProperties(value={"type"})
    private static final class ModifierListValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectModifierList value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ModifierListValue() {
        }

        private ModifierListValue(CatalogObjectModifierList value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitModifierList(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ModifierListValue && this.equalTo((ModifierListValue)other);
        }

        private boolean equalTo(ModifierListValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="DISCOUNT")
    @JsonIgnoreProperties(value={"type"})
    private static final class DiscountValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectDiscount value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private DiscountValue() {
        }

        private DiscountValue(CatalogObjectDiscount value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitDiscount(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof DiscountValue && this.equalTo((DiscountValue)other);
        }

        private boolean equalTo(DiscountValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="TAX")
    @JsonIgnoreProperties(value={"type"})
    private static final class TaxValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectTax value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TaxValue() {
        }

        private TaxValue(CatalogObjectTax value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitTax(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TaxValue && this.equalTo((TaxValue)other);
        }

        private boolean equalTo(TaxValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="ITEM_VARIATION")
    @JsonIgnoreProperties(value={"type"})
    private static final class ItemVariationValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectItemVariation value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ItemVariationValue() {
        }

        private ItemVariationValue(CatalogObjectItemVariation value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitItemVariation(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ItemVariationValue && this.equalTo((ItemVariationValue)other);
        }

        private boolean equalTo(ItemVariationValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="CATEGORY")
    @JsonIgnoreProperties(value={"type"})
    private static final class CategoryValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectCategory value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private CategoryValue() {
        }

        private CategoryValue(CatalogObjectCategory value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitCategory(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CategoryValue && this.equalTo((CategoryValue)other);
        }

        private boolean equalTo(CategoryValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="IMAGE")
    @JsonIgnoreProperties(value={"type"})
    private static final class ImageValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectImage value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ImageValue() {
        }

        private ImageValue(CatalogObjectImage value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitImage(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ImageValue && this.equalTo((ImageValue)other);
        }

        private boolean equalTo(ImageValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="ITEM")
    @JsonIgnoreProperties(value={"type"})
    private static final class ItemValue
    implements Value {
        @JsonUnwrapped
        private CatalogObjectItem value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ItemValue() {
        }

        private ItemValue(CatalogObjectItem value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitItem(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ItemValue && this.equalTo((ItemValue)other);
        }

        private boolean equalTo(ItemValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CatalogObject{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ItemValue.class), @JsonSubTypes.Type(value=ImageValue.class), @JsonSubTypes.Type(value=CategoryValue.class), @JsonSubTypes.Type(value=ItemVariationValue.class), @JsonSubTypes.Type(value=TaxValue.class), @JsonSubTypes.Type(value=DiscountValue.class), @JsonSubTypes.Type(value=ModifierListValue.class), @JsonSubTypes.Type(value=ModifierValue.class), @JsonSubTypes.Type(value=PricingRuleValue.class), @JsonSubTypes.Type(value=ProductSetValue.class), @JsonSubTypes.Type(value=TimePeriodValue.class), @JsonSubTypes.Type(value=MeasurementUnitValue.class), @JsonSubTypes.Type(value=SubscriptionPlanVariationValue.class), @JsonSubTypes.Type(value=ItemOptionValue.class), @JsonSubTypes.Type(value=ItemOptionValValue.class), @JsonSubTypes.Type(value=CustomAttributeDefinitionValue.class), @JsonSubTypes.Type(value=QuickAmountsSettingsValue.class), @JsonSubTypes.Type(value=SubscriptionPlanValue.class), @JsonSubTypes.Type(value=AvailabilityPeriodValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitItem(CatalogObjectItem var1);

        public T visitImage(CatalogObjectImage var1);

        public T visitCategory(CatalogObjectCategory var1);

        public T visitItemVariation(CatalogObjectItemVariation var1);

        public T visitTax(CatalogObjectTax var1);

        public T visitDiscount(CatalogObjectDiscount var1);

        public T visitModifierList(CatalogObjectModifierList var1);

        public T visitModifier(CatalogObjectModifier var1);

        public T visitPricingRule(CatalogObjectPricingRule var1);

        public T visitProductSet(CatalogObjectProductSet var1);

        public T visitTimePeriod(CatalogObjectTimePeriod var1);

        public T visitMeasurementUnit(CatalogObjectMeasurementUnit var1);

        public T visitSubscriptionPlanVariation(CatalogObjectSubscriptionPlanVariation var1);

        public T visitItemOption(CatalogObjectItemOption var1);

        public T visitItemOptionVal(CatalogObjectItemOptionValue var1);

        public T visitCustomAttributeDefinition(CatalogObjectCustomAttributeDefinition var1);

        public T visitQuickAmountsSettings(CatalogObjectQuickAmountsSettings var1);

        public T visitSubscriptionPlan(CatalogObjectSubscriptionPlan var1);

        public T visitAvailabilityPeriod(CatalogObjectAvailabilityPeriod var1);

        public T _visitUnknown(Object var1);
    }
}

