/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogModifierOverride {
    private final String modifierId;
    private final Optional<Boolean> onByDefault;
    private final Optional<Object> hiddenOnlineOverride;
    private final Optional<Object> onByDefaultOverride;
    private final Map<String, Object> additionalProperties;

    private CatalogModifierOverride(String modifierId, Optional<Boolean> onByDefault, Optional<Object> hiddenOnlineOverride, Optional<Object> onByDefaultOverride, Map<String, Object> additionalProperties) {
        this.modifierId = modifierId;
        this.onByDefault = onByDefault;
        this.hiddenOnlineOverride = hiddenOnlineOverride;
        this.onByDefaultOverride = onByDefaultOverride;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="modifier_id")
    public String getModifierId() {
        return this.modifierId;
    }

    @JsonIgnore
    public Optional<Boolean> getOnByDefault() {
        if (this.onByDefault == null) {
            return Optional.empty();
        }
        return this.onByDefault;
    }

    @JsonProperty(value="hidden_online_override")
    public Optional<Object> getHiddenOnlineOverride() {
        return this.hiddenOnlineOverride;
    }

    @JsonProperty(value="on_by_default_override")
    public Optional<Object> getOnByDefaultOverride() {
        return this.onByDefaultOverride;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="on_by_default")
    private Optional<Boolean> _getOnByDefault() {
        return this.onByDefault;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogModifierOverride && this.equalTo((CatalogModifierOverride)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogModifierOverride other) {
        return this.modifierId.equals(other.modifierId) && this.onByDefault.equals(other.onByDefault) && this.hiddenOnlineOverride.equals(other.hiddenOnlineOverride) && this.onByDefaultOverride.equals(other.onByDefaultOverride);
    }

    public int hashCode() {
        return Objects.hash(this.modifierId, this.onByDefault, this.hiddenOnlineOverride, this.onByDefaultOverride);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModifierIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModifierIdStage,
    _FinalStage {
        private String modifierId;
        private Optional<Object> onByDefaultOverride = Optional.empty();
        private Optional<Object> hiddenOnlineOverride = Optional.empty();
        private Optional<Boolean> onByDefault = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogModifierOverride other) {
            this.modifierId(other.getModifierId());
            this.onByDefault(other.getOnByDefault());
            this.hiddenOnlineOverride(other.getHiddenOnlineOverride());
            this.onByDefaultOverride(other.getOnByDefaultOverride());
            return this;
        }

        @Override
        @JsonSetter(value="modifier_id")
        public _FinalStage modifierId(@NotNull String modifierId) {
            this.modifierId = Objects.requireNonNull(modifierId, "modifierId must not be null");
            return this;
        }

        @Override
        public _FinalStage onByDefaultOverride(Object onByDefaultOverride) {
            this.onByDefaultOverride = Optional.ofNullable(onByDefaultOverride);
            return this;
        }

        @Override
        @JsonSetter(value="on_by_default_override", nulls=Nulls.SKIP)
        public _FinalStage onByDefaultOverride(Optional<Object> onByDefaultOverride) {
            this.onByDefaultOverride = onByDefaultOverride;
            return this;
        }

        @Override
        public _FinalStage hiddenOnlineOverride(Object hiddenOnlineOverride) {
            this.hiddenOnlineOverride = Optional.ofNullable(hiddenOnlineOverride);
            return this;
        }

        @Override
        @JsonSetter(value="hidden_online_override", nulls=Nulls.SKIP)
        public _FinalStage hiddenOnlineOverride(Optional<Object> hiddenOnlineOverride) {
            this.hiddenOnlineOverride = hiddenOnlineOverride;
            return this;
        }

        @Override
        public _FinalStage onByDefault(Nullable<Boolean> onByDefault) {
            this.onByDefault = onByDefault.isNull() ? null : (onByDefault.isEmpty() ? Optional.empty() : Optional.of(onByDefault.get()));
            return this;
        }

        @Override
        public _FinalStage onByDefault(Boolean onByDefault) {
            this.onByDefault = Optional.ofNullable(onByDefault);
            return this;
        }

        @Override
        @JsonSetter(value="on_by_default", nulls=Nulls.SKIP)
        public _FinalStage onByDefault(Optional<Boolean> onByDefault) {
            this.onByDefault = onByDefault;
            return this;
        }

        @Override
        public CatalogModifierOverride build() {
            return new CatalogModifierOverride(this.modifierId, this.onByDefault, this.hiddenOnlineOverride, this.onByDefaultOverride, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogModifierOverride build();

        public _FinalStage onByDefault(Optional<Boolean> var1);

        public _FinalStage onByDefault(Boolean var1);

        public _FinalStage onByDefault(Nullable<Boolean> var1);

        public _FinalStage hiddenOnlineOverride(Optional<Object> var1);

        public _FinalStage hiddenOnlineOverride(Object var1);

        public _FinalStage onByDefaultOverride(Optional<Object> var1);

        public _FinalStage onByDefaultOverride(Object var1);
    }

    public static interface ModifierIdStage {
        public _FinalStage modifierId(@NotNull String var1);

        public Builder from(CatalogModifierOverride var1);
    }
}

