/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogModifierListModifierType;
import com.squareup.square.types.CatalogModifierListSelectionType;
import com.squareup.square.types.CatalogObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogModifierList {
    private final Optional<String> name;
    private final Optional<Integer> ordinal;
    private final Optional<CatalogModifierListSelectionType> selectionType;
    private final Optional<List<CatalogObject>> modifiers;
    private final Optional<List<String>> imageIds;
    private final Optional<Boolean> allowQuantities;
    private final Optional<Boolean> isConversational;
    private final Optional<CatalogModifierListModifierType> modifierType;
    private final Optional<Integer> maxLength;
    private final Optional<Boolean> textRequired;
    private final Optional<String> internalName;
    private final Optional<Long> minSelectedModifiers;
    private final Optional<Long> maxSelectedModifiers;
    private final Optional<Boolean> hiddenFromCustomer;
    private final Map<String, Object> additionalProperties;

    private CatalogModifierList(Optional<String> name, Optional<Integer> ordinal, Optional<CatalogModifierListSelectionType> selectionType, Optional<List<CatalogObject>> modifiers, Optional<List<String>> imageIds, Optional<Boolean> allowQuantities, Optional<Boolean> isConversational, Optional<CatalogModifierListModifierType> modifierType, Optional<Integer> maxLength, Optional<Boolean> textRequired, Optional<String> internalName, Optional<Long> minSelectedModifiers, Optional<Long> maxSelectedModifiers, Optional<Boolean> hiddenFromCustomer, Map<String, Object> additionalProperties) {
        this.name = name;
        this.ordinal = ordinal;
        this.selectionType = selectionType;
        this.modifiers = modifiers;
        this.imageIds = imageIds;
        this.allowQuantities = allowQuantities;
        this.isConversational = isConversational;
        this.modifierType = modifierType;
        this.maxLength = maxLength;
        this.textRequired = textRequired;
        this.internalName = internalName;
        this.minSelectedModifiers = minSelectedModifiers;
        this.maxSelectedModifiers = maxSelectedModifiers;
        this.hiddenFromCustomer = hiddenFromCustomer;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<Integer> getOrdinal() {
        if (this.ordinal == null) {
            return Optional.empty();
        }
        return this.ordinal;
    }

    @JsonProperty(value="selection_type")
    public Optional<CatalogModifierListSelectionType> getSelectionType() {
        return this.selectionType;
    }

    @JsonIgnore
    public Optional<List<CatalogObject>> getModifiers() {
        if (this.modifiers == null) {
            return Optional.empty();
        }
        return this.modifiers;
    }

    @JsonIgnore
    public Optional<List<String>> getImageIds() {
        if (this.imageIds == null) {
            return Optional.empty();
        }
        return this.imageIds;
    }

    @JsonIgnore
    public Optional<Boolean> getAllowQuantities() {
        if (this.allowQuantities == null) {
            return Optional.empty();
        }
        return this.allowQuantities;
    }

    @JsonIgnore
    public Optional<Boolean> getIsConversational() {
        if (this.isConversational == null) {
            return Optional.empty();
        }
        return this.isConversational;
    }

    @JsonProperty(value="modifier_type")
    public Optional<CatalogModifierListModifierType> getModifierType() {
        return this.modifierType;
    }

    @JsonIgnore
    public Optional<Integer> getMaxLength() {
        if (this.maxLength == null) {
            return Optional.empty();
        }
        return this.maxLength;
    }

    @JsonIgnore
    public Optional<Boolean> getTextRequired() {
        if (this.textRequired == null) {
            return Optional.empty();
        }
        return this.textRequired;
    }

    @JsonIgnore
    public Optional<String> getInternalName() {
        if (this.internalName == null) {
            return Optional.empty();
        }
        return this.internalName;
    }

    @JsonIgnore
    public Optional<Long> getMinSelectedModifiers() {
        if (this.minSelectedModifiers == null) {
            return Optional.empty();
        }
        return this.minSelectedModifiers;
    }

    @JsonIgnore
    public Optional<Long> getMaxSelectedModifiers() {
        if (this.maxSelectedModifiers == null) {
            return Optional.empty();
        }
        return this.maxSelectedModifiers;
    }

    @JsonIgnore
    public Optional<Boolean> getHiddenFromCustomer() {
        if (this.hiddenFromCustomer == null) {
            return Optional.empty();
        }
        return this.hiddenFromCustomer;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ordinal")
    private Optional<Integer> _getOrdinal() {
        return this.ordinal;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="modifiers")
    private Optional<List<CatalogObject>> _getModifiers() {
        return this.modifiers;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="image_ids")
    private Optional<List<String>> _getImageIds() {
        return this.imageIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="allow_quantities")
    private Optional<Boolean> _getAllowQuantities() {
        return this.allowQuantities;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_conversational")
    private Optional<Boolean> _getIsConversational() {
        return this.isConversational;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="max_length")
    private Optional<Integer> _getMaxLength() {
        return this.maxLength;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="text_required")
    private Optional<Boolean> _getTextRequired() {
        return this.textRequired;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="internal_name")
    private Optional<String> _getInternalName() {
        return this.internalName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="min_selected_modifiers")
    private Optional<Long> _getMinSelectedModifiers() {
        return this.minSelectedModifiers;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="max_selected_modifiers")
    private Optional<Long> _getMaxSelectedModifiers() {
        return this.maxSelectedModifiers;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="hidden_from_customer")
    private Optional<Boolean> _getHiddenFromCustomer() {
        return this.hiddenFromCustomer;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogModifierList && this.equalTo((CatalogModifierList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogModifierList other) {
        return this.name.equals(other.name) && this.ordinal.equals(other.ordinal) && this.selectionType.equals(other.selectionType) && this.modifiers.equals(other.modifiers) && this.imageIds.equals(other.imageIds) && this.allowQuantities.equals(other.allowQuantities) && this.isConversational.equals(other.isConversational) && this.modifierType.equals(other.modifierType) && this.maxLength.equals(other.maxLength) && this.textRequired.equals(other.textRequired) && this.internalName.equals(other.internalName) && this.minSelectedModifiers.equals(other.minSelectedModifiers) && this.maxSelectedModifiers.equals(other.maxSelectedModifiers) && this.hiddenFromCustomer.equals(other.hiddenFromCustomer);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ordinal, this.selectionType, this.modifiers, this.imageIds, this.allowQuantities, this.isConversational, this.modifierType, this.maxLength, this.textRequired, this.internalName, this.minSelectedModifiers, this.maxSelectedModifiers, this.hiddenFromCustomer);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<Integer> ordinal = Optional.empty();
        private Optional<CatalogModifierListSelectionType> selectionType = Optional.empty();
        private Optional<List<CatalogObject>> modifiers = Optional.empty();
        private Optional<List<String>> imageIds = Optional.empty();
        private Optional<Boolean> allowQuantities = Optional.empty();
        private Optional<Boolean> isConversational = Optional.empty();
        private Optional<CatalogModifierListModifierType> modifierType = Optional.empty();
        private Optional<Integer> maxLength = Optional.empty();
        private Optional<Boolean> textRequired = Optional.empty();
        private Optional<String> internalName = Optional.empty();
        private Optional<Long> minSelectedModifiers = Optional.empty();
        private Optional<Long> maxSelectedModifiers = Optional.empty();
        private Optional<Boolean> hiddenFromCustomer = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogModifierList other) {
            this.name(other.getName());
            this.ordinal(other.getOrdinal());
            this.selectionType(other.getSelectionType());
            this.modifiers(other.getModifiers());
            this.imageIds(other.getImageIds());
            this.allowQuantities(other.getAllowQuantities());
            this.isConversational(other.getIsConversational());
            this.modifierType(other.getModifierType());
            this.maxLength(other.getMaxLength());
            this.textRequired(other.getTextRequired());
            this.internalName(other.getInternalName());
            this.minSelectedModifiers(other.getMinSelectedModifiers());
            this.maxSelectedModifiers(other.getMaxSelectedModifiers());
            this.hiddenFromCustomer(other.getHiddenFromCustomer());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="ordinal", nulls=Nulls.SKIP)
        public Builder ordinal(Optional<Integer> ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder ordinal(Integer ordinal) {
            this.ordinal = Optional.ofNullable(ordinal);
            return this;
        }

        public Builder ordinal(Nullable<Integer> ordinal) {
            this.ordinal = ordinal.isNull() ? null : (ordinal.isEmpty() ? Optional.empty() : Optional.of(ordinal.get()));
            return this;
        }

        @JsonSetter(value="selection_type", nulls=Nulls.SKIP)
        public Builder selectionType(Optional<CatalogModifierListSelectionType> selectionType) {
            this.selectionType = selectionType;
            return this;
        }

        public Builder selectionType(CatalogModifierListSelectionType selectionType) {
            this.selectionType = Optional.ofNullable(selectionType);
            return this;
        }

        @JsonSetter(value="modifiers", nulls=Nulls.SKIP)
        public Builder modifiers(Optional<List<CatalogObject>> modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public Builder modifiers(List<CatalogObject> modifiers) {
            this.modifiers = Optional.ofNullable(modifiers);
            return this;
        }

        public Builder modifiers(Nullable<List<CatalogObject>> modifiers) {
            this.modifiers = modifiers.isNull() ? null : (modifiers.isEmpty() ? Optional.empty() : Optional.of(modifiers.get()));
            return this;
        }

        @JsonSetter(value="image_ids", nulls=Nulls.SKIP)
        public Builder imageIds(Optional<List<String>> imageIds) {
            this.imageIds = imageIds;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = Optional.ofNullable(imageIds);
            return this;
        }

        public Builder imageIds(Nullable<List<String>> imageIds) {
            this.imageIds = imageIds.isNull() ? null : (imageIds.isEmpty() ? Optional.empty() : Optional.of(imageIds.get()));
            return this;
        }

        @JsonSetter(value="allow_quantities", nulls=Nulls.SKIP)
        public Builder allowQuantities(Optional<Boolean> allowQuantities) {
            this.allowQuantities = allowQuantities;
            return this;
        }

        public Builder allowQuantities(Boolean allowQuantities) {
            this.allowQuantities = Optional.ofNullable(allowQuantities);
            return this;
        }

        public Builder allowQuantities(Nullable<Boolean> allowQuantities) {
            this.allowQuantities = allowQuantities.isNull() ? null : (allowQuantities.isEmpty() ? Optional.empty() : Optional.of(allowQuantities.get()));
            return this;
        }

        @JsonSetter(value="is_conversational", nulls=Nulls.SKIP)
        public Builder isConversational(Optional<Boolean> isConversational) {
            this.isConversational = isConversational;
            return this;
        }

        public Builder isConversational(Boolean isConversational) {
            this.isConversational = Optional.ofNullable(isConversational);
            return this;
        }

        public Builder isConversational(Nullable<Boolean> isConversational) {
            this.isConversational = isConversational.isNull() ? null : (isConversational.isEmpty() ? Optional.empty() : Optional.of(isConversational.get()));
            return this;
        }

        @JsonSetter(value="modifier_type", nulls=Nulls.SKIP)
        public Builder modifierType(Optional<CatalogModifierListModifierType> modifierType) {
            this.modifierType = modifierType;
            return this;
        }

        public Builder modifierType(CatalogModifierListModifierType modifierType) {
            this.modifierType = Optional.ofNullable(modifierType);
            return this;
        }

        @JsonSetter(value="max_length", nulls=Nulls.SKIP)
        public Builder maxLength(Optional<Integer> maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder maxLength(Integer maxLength) {
            this.maxLength = Optional.ofNullable(maxLength);
            return this;
        }

        public Builder maxLength(Nullable<Integer> maxLength) {
            this.maxLength = maxLength.isNull() ? null : (maxLength.isEmpty() ? Optional.empty() : Optional.of(maxLength.get()));
            return this;
        }

        @JsonSetter(value="text_required", nulls=Nulls.SKIP)
        public Builder textRequired(Optional<Boolean> textRequired) {
            this.textRequired = textRequired;
            return this;
        }

        public Builder textRequired(Boolean textRequired) {
            this.textRequired = Optional.ofNullable(textRequired);
            return this;
        }

        public Builder textRequired(Nullable<Boolean> textRequired) {
            this.textRequired = textRequired.isNull() ? null : (textRequired.isEmpty() ? Optional.empty() : Optional.of(textRequired.get()));
            return this;
        }

        @JsonSetter(value="internal_name", nulls=Nulls.SKIP)
        public Builder internalName(Optional<String> internalName) {
            this.internalName = internalName;
            return this;
        }

        public Builder internalName(String internalName) {
            this.internalName = Optional.ofNullable(internalName);
            return this;
        }

        public Builder internalName(Nullable<String> internalName) {
            this.internalName = internalName.isNull() ? null : (internalName.isEmpty() ? Optional.empty() : Optional.of(internalName.get()));
            return this;
        }

        @JsonSetter(value="min_selected_modifiers", nulls=Nulls.SKIP)
        public Builder minSelectedModifiers(Optional<Long> minSelectedModifiers) {
            this.minSelectedModifiers = minSelectedModifiers;
            return this;
        }

        public Builder minSelectedModifiers(Long minSelectedModifiers) {
            this.minSelectedModifiers = Optional.ofNullable(minSelectedModifiers);
            return this;
        }

        public Builder minSelectedModifiers(Nullable<Long> minSelectedModifiers) {
            this.minSelectedModifiers = minSelectedModifiers.isNull() ? null : (minSelectedModifiers.isEmpty() ? Optional.empty() : Optional.of(minSelectedModifiers.get()));
            return this;
        }

        @JsonSetter(value="max_selected_modifiers", nulls=Nulls.SKIP)
        public Builder maxSelectedModifiers(Optional<Long> maxSelectedModifiers) {
            this.maxSelectedModifiers = maxSelectedModifiers;
            return this;
        }

        public Builder maxSelectedModifiers(Long maxSelectedModifiers) {
            this.maxSelectedModifiers = Optional.ofNullable(maxSelectedModifiers);
            return this;
        }

        public Builder maxSelectedModifiers(Nullable<Long> maxSelectedModifiers) {
            this.maxSelectedModifiers = maxSelectedModifiers.isNull() ? null : (maxSelectedModifiers.isEmpty() ? Optional.empty() : Optional.of(maxSelectedModifiers.get()));
            return this;
        }

        @JsonSetter(value="hidden_from_customer", nulls=Nulls.SKIP)
        public Builder hiddenFromCustomer(Optional<Boolean> hiddenFromCustomer) {
            this.hiddenFromCustomer = hiddenFromCustomer;
            return this;
        }

        public Builder hiddenFromCustomer(Boolean hiddenFromCustomer) {
            this.hiddenFromCustomer = Optional.ofNullable(hiddenFromCustomer);
            return this;
        }

        public Builder hiddenFromCustomer(Nullable<Boolean> hiddenFromCustomer) {
            this.hiddenFromCustomer = hiddenFromCustomer.isNull() ? null : (hiddenFromCustomer.isEmpty() ? Optional.empty() : Optional.of(hiddenFromCustomer.get()));
            return this;
        }

        public CatalogModifierList build() {
            return new CatalogModifierList(this.name, this.ordinal, this.selectionType, this.modifiers, this.imageIds, this.allowQuantities, this.isConversational, this.modifierType, this.maxLength, this.textRequired, this.internalName, this.minSelectedModifiers, this.maxSelectedModifiers, this.hiddenFromCustomer, this.additionalProperties);
        }
    }
}

