/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogItemOptionValueForItemVariation {
    private final Optional<String> itemOptionId;
    private final Optional<String> itemOptionValueId;
    private final Map<String, Object> additionalProperties;

    private CatalogItemOptionValueForItemVariation(Optional<String> itemOptionId, Optional<String> itemOptionValueId, Map<String, Object> additionalProperties) {
        this.itemOptionId = itemOptionId;
        this.itemOptionValueId = itemOptionValueId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getItemOptionId() {
        if (this.itemOptionId == null) {
            return Optional.empty();
        }
        return this.itemOptionId;
    }

    @JsonIgnore
    public Optional<String> getItemOptionValueId() {
        if (this.itemOptionValueId == null) {
            return Optional.empty();
        }
        return this.itemOptionValueId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="item_option_id")
    private Optional<String> _getItemOptionId() {
        return this.itemOptionId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="item_option_value_id")
    private Optional<String> _getItemOptionValueId() {
        return this.itemOptionValueId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogItemOptionValueForItemVariation && this.equalTo((CatalogItemOptionValueForItemVariation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogItemOptionValueForItemVariation other) {
        return this.itemOptionId.equals(other.itemOptionId) && this.itemOptionValueId.equals(other.itemOptionValueId);
    }

    public int hashCode() {
        return Objects.hash(this.itemOptionId, this.itemOptionValueId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> itemOptionId = Optional.empty();
        private Optional<String> itemOptionValueId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogItemOptionValueForItemVariation other) {
            this.itemOptionId(other.getItemOptionId());
            this.itemOptionValueId(other.getItemOptionValueId());
            return this;
        }

        @JsonSetter(value="item_option_id", nulls=Nulls.SKIP)
        public Builder itemOptionId(Optional<String> itemOptionId) {
            this.itemOptionId = itemOptionId;
            return this;
        }

        public Builder itemOptionId(String itemOptionId) {
            this.itemOptionId = Optional.ofNullable(itemOptionId);
            return this;
        }

        public Builder itemOptionId(Nullable<String> itemOptionId) {
            this.itemOptionId = itemOptionId.isNull() ? null : (itemOptionId.isEmpty() ? Optional.empty() : Optional.of(itemOptionId.get()));
            return this;
        }

        @JsonSetter(value="item_option_value_id", nulls=Nulls.SKIP)
        public Builder itemOptionValueId(Optional<String> itemOptionValueId) {
            this.itemOptionValueId = itemOptionValueId;
            return this;
        }

        public Builder itemOptionValueId(String itemOptionValueId) {
            this.itemOptionValueId = Optional.ofNullable(itemOptionValueId);
            return this;
        }

        public Builder itemOptionValueId(Nullable<String> itemOptionValueId) {
            this.itemOptionValueId = itemOptionValueId.isNull() ? null : (itemOptionValueId.isEmpty() ? Optional.empty() : Optional.of(itemOptionValueId.get()));
            return this;
        }

        public CatalogItemOptionValueForItemVariation build() {
            return new CatalogItemOptionValueForItemVariation(this.itemOptionId, this.itemOptionValueId, this.additionalProperties);
        }
    }
}

