/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogItemOptionValue {
    private final Optional<String> itemOptionId;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<String> color;
    private final Optional<Integer> ordinal;
    private final Map<String, Object> additionalProperties;

    private CatalogItemOptionValue(Optional<String> itemOptionId, Optional<String> name, Optional<String> description, Optional<String> color, Optional<Integer> ordinal, Map<String, Object> additionalProperties) {
        this.itemOptionId = itemOptionId;
        this.name = name;
        this.description = description;
        this.color = color;
        this.ordinal = ordinal;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getItemOptionId() {
        if (this.itemOptionId == null) {
            return Optional.empty();
        }
        return this.itemOptionId;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonIgnore
    public Optional<String> getColor() {
        if (this.color == null) {
            return Optional.empty();
        }
        return this.color;
    }

    @JsonIgnore
    public Optional<Integer> getOrdinal() {
        if (this.ordinal == null) {
            return Optional.empty();
        }
        return this.ordinal;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="item_option_id")
    private Optional<String> _getItemOptionId() {
        return this.itemOptionId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="color")
    private Optional<String> _getColor() {
        return this.color;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ordinal")
    private Optional<Integer> _getOrdinal() {
        return this.ordinal;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogItemOptionValue && this.equalTo((CatalogItemOptionValue)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogItemOptionValue other) {
        return this.itemOptionId.equals(other.itemOptionId) && this.name.equals(other.name) && this.description.equals(other.description) && this.color.equals(other.color) && this.ordinal.equals(other.ordinal);
    }

    public int hashCode() {
        return Objects.hash(this.itemOptionId, this.name, this.description, this.color, this.ordinal);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> itemOptionId = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> color = Optional.empty();
        private Optional<Integer> ordinal = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogItemOptionValue other) {
            this.itemOptionId(other.getItemOptionId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.color(other.getColor());
            this.ordinal(other.getOrdinal());
            return this;
        }

        @JsonSetter(value="item_option_id", nulls=Nulls.SKIP)
        public Builder itemOptionId(Optional<String> itemOptionId) {
            this.itemOptionId = itemOptionId;
            return this;
        }

        public Builder itemOptionId(String itemOptionId) {
            this.itemOptionId = Optional.ofNullable(itemOptionId);
            return this;
        }

        public Builder itemOptionId(Nullable<String> itemOptionId) {
            this.itemOptionId = itemOptionId.isNull() ? null : (itemOptionId.isEmpty() ? Optional.empty() : Optional.of(itemOptionId.get()));
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @JsonSetter(value="color", nulls=Nulls.SKIP)
        public Builder color(Optional<String> color) {
            this.color = color;
            return this;
        }

        public Builder color(String color) {
            this.color = Optional.ofNullable(color);
            return this;
        }

        public Builder color(Nullable<String> color) {
            this.color = color.isNull() ? null : (color.isEmpty() ? Optional.empty() : Optional.of(color.get()));
            return this;
        }

        @JsonSetter(value="ordinal", nulls=Nulls.SKIP)
        public Builder ordinal(Optional<Integer> ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder ordinal(Integer ordinal) {
            this.ordinal = Optional.ofNullable(ordinal);
            return this;
        }

        public Builder ordinal(Nullable<Integer> ordinal) {
            this.ordinal = ordinal.isNull() ? null : (ordinal.isEmpty() ? Optional.empty() : Optional.of(ordinal.get()));
            return this;
        }

        public CatalogItemOptionValue build() {
            return new CatalogItemOptionValue(this.itemOptionId, this.name, this.description, this.color, this.ordinal, this.additionalProperties);
        }
    }
}

