/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogImage {
    private final Optional<String> name;
    private final Optional<String> url;
    private final Optional<String> caption;
    private final Optional<String> photoStudioOrderId;
    private final Map<String, Object> additionalProperties;

    private CatalogImage(Optional<String> name, Optional<String> url, Optional<String> caption, Optional<String> photoStudioOrderId, Map<String, Object> additionalProperties) {
        this.name = name;
        this.url = url;
        this.caption = caption;
        this.photoStudioOrderId = photoStudioOrderId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getUrl() {
        if (this.url == null) {
            return Optional.empty();
        }
        return this.url;
    }

    @JsonIgnore
    public Optional<String> getCaption() {
        if (this.caption == null) {
            return Optional.empty();
        }
        return this.caption;
    }

    @JsonIgnore
    public Optional<String> getPhotoStudioOrderId() {
        if (this.photoStudioOrderId == null) {
            return Optional.empty();
        }
        return this.photoStudioOrderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="url")
    private Optional<String> _getUrl() {
        return this.url;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="caption")
    private Optional<String> _getCaption() {
        return this.caption;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="photo_studio_order_id")
    private Optional<String> _getPhotoStudioOrderId() {
        return this.photoStudioOrderId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogImage && this.equalTo((CatalogImage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogImage other) {
        return this.name.equals(other.name) && this.url.equals(other.url) && this.caption.equals(other.caption) && this.photoStudioOrderId.equals(other.photoStudioOrderId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.caption, this.photoStudioOrderId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<String> caption = Optional.empty();
        private Optional<String> photoStudioOrderId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogImage other) {
            this.name(other.getName());
            this.url(other.getUrl());
            this.caption(other.getCaption());
            this.photoStudioOrderId(other.getPhotoStudioOrderId());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        public Builder url(Nullable<String> url) {
            this.url = url.isNull() ? null : (url.isEmpty() ? Optional.empty() : Optional.of(url.get()));
            return this;
        }

        @JsonSetter(value="caption", nulls=Nulls.SKIP)
        public Builder caption(Optional<String> caption) {
            this.caption = caption;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = Optional.ofNullable(caption);
            return this;
        }

        public Builder caption(Nullable<String> caption) {
            this.caption = caption.isNull() ? null : (caption.isEmpty() ? Optional.empty() : Optional.of(caption.get()));
            return this;
        }

        @JsonSetter(value="photo_studio_order_id", nulls=Nulls.SKIP)
        public Builder photoStudioOrderId(Optional<String> photoStudioOrderId) {
            this.photoStudioOrderId = photoStudioOrderId;
            return this;
        }

        public Builder photoStudioOrderId(String photoStudioOrderId) {
            this.photoStudioOrderId = Optional.ofNullable(photoStudioOrderId);
            return this;
        }

        public Builder photoStudioOrderId(Nullable<String> photoStudioOrderId) {
            this.photoStudioOrderId = photoStudioOrderId.isNull() ? null : (photoStudioOrderId.isEmpty() ? Optional.empty() : Optional.of(photoStudioOrderId.get()));
            return this;
        }

        public CatalogImage build() {
            return new CatalogImage(this.name, this.url, this.caption, this.photoStudioOrderId, this.additionalProperties);
        }
    }
}

