/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class CatalogDiscountType {
    public static final CatalogDiscountType FIXED_PERCENTAGE = new CatalogDiscountType(Value.FIXED_PERCENTAGE, "FIXED_PERCENTAGE");
    public static final CatalogDiscountType FIXED_AMOUNT = new CatalogDiscountType(Value.FIXED_AMOUNT, "FIXED_AMOUNT");
    public static final CatalogDiscountType VARIABLE_AMOUNT = new CatalogDiscountType(Value.VARIABLE_AMOUNT, "VARIABLE_AMOUNT");
    public static final CatalogDiscountType VARIABLE_PERCENTAGE = new CatalogDiscountType(Value.VARIABLE_PERCENTAGE, "VARIABLE_PERCENTAGE");
    private final Value value;
    private final String string;

    CatalogDiscountType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CatalogDiscountType && this.string.equals(((CatalogDiscountType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case FIXED_PERCENTAGE: {
                return visitor.visitFixedPercentage();
            }
            case FIXED_AMOUNT: {
                return visitor.visitFixedAmount();
            }
            case VARIABLE_AMOUNT: {
                return visitor.visitVariableAmount();
            }
            case VARIABLE_PERCENTAGE: {
                return visitor.visitVariablePercentage();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static CatalogDiscountType valueOf(String value) {
        switch (value) {
            case "FIXED_PERCENTAGE": {
                return FIXED_PERCENTAGE;
            }
            case "FIXED_AMOUNT": {
                return FIXED_AMOUNT;
            }
            case "VARIABLE_AMOUNT": {
                return VARIABLE_AMOUNT;
            }
            case "VARIABLE_PERCENTAGE": {
                return VARIABLE_PERCENTAGE;
            }
        }
        return new CatalogDiscountType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitFixedPercentage();

        public T visitFixedAmount();

        public T visitVariablePercentage();

        public T visitVariableAmount();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        FIXED_PERCENTAGE,
        FIXED_AMOUNT,
        VARIABLE_PERCENTAGE,
        VARIABLE_AMOUNT,
        UNKNOWN;

    }
}

