/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogCustomAttributeDefinitionSelectionConfig {
    private final Optional<Integer> maxAllowedSelections;
    private final Optional<List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection>> allowedSelections;
    private final Map<String, Object> additionalProperties;

    private CatalogCustomAttributeDefinitionSelectionConfig(Optional<Integer> maxAllowedSelections, Optional<List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection>> allowedSelections, Map<String, Object> additionalProperties) {
        this.maxAllowedSelections = maxAllowedSelections;
        this.allowedSelections = allowedSelections;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Integer> getMaxAllowedSelections() {
        if (this.maxAllowedSelections == null) {
            return Optional.empty();
        }
        return this.maxAllowedSelections;
    }

    @JsonIgnore
    public Optional<List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection>> getAllowedSelections() {
        if (this.allowedSelections == null) {
            return Optional.empty();
        }
        return this.allowedSelections;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="max_allowed_selections")
    private Optional<Integer> _getMaxAllowedSelections() {
        return this.maxAllowedSelections;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="allowed_selections")
    private Optional<List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection>> _getAllowedSelections() {
        return this.allowedSelections;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogCustomAttributeDefinitionSelectionConfig && this.equalTo((CatalogCustomAttributeDefinitionSelectionConfig)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogCustomAttributeDefinitionSelectionConfig other) {
        return this.maxAllowedSelections.equals(other.maxAllowedSelections) && this.allowedSelections.equals(other.allowedSelections);
    }

    public int hashCode() {
        return Objects.hash(this.maxAllowedSelections, this.allowedSelections);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> maxAllowedSelections = Optional.empty();
        private Optional<List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection>> allowedSelections = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogCustomAttributeDefinitionSelectionConfig other) {
            this.maxAllowedSelections(other.getMaxAllowedSelections());
            this.allowedSelections(other.getAllowedSelections());
            return this;
        }

        @JsonSetter(value="max_allowed_selections", nulls=Nulls.SKIP)
        public Builder maxAllowedSelections(Optional<Integer> maxAllowedSelections) {
            this.maxAllowedSelections = maxAllowedSelections;
            return this;
        }

        public Builder maxAllowedSelections(Integer maxAllowedSelections) {
            this.maxAllowedSelections = Optional.ofNullable(maxAllowedSelections);
            return this;
        }

        public Builder maxAllowedSelections(Nullable<Integer> maxAllowedSelections) {
            this.maxAllowedSelections = maxAllowedSelections.isNull() ? null : (maxAllowedSelections.isEmpty() ? Optional.empty() : Optional.of(maxAllowedSelections.get()));
            return this;
        }

        @JsonSetter(value="allowed_selections", nulls=Nulls.SKIP)
        public Builder allowedSelections(Optional<List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection>> allowedSelections) {
            this.allowedSelections = allowedSelections;
            return this;
        }

        public Builder allowedSelections(List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection> allowedSelections) {
            this.allowedSelections = Optional.ofNullable(allowedSelections);
            return this;
        }

        public Builder allowedSelections(Nullable<List<CatalogCustomAttributeDefinitionSelectionConfigCustomAttributeSelection>> allowedSelections) {
            this.allowedSelections = allowedSelections.isNull() ? null : (allowedSelections.isEmpty() ? Optional.empty() : Optional.of(allowedSelections.get()));
            return this;
        }

        public CatalogCustomAttributeDefinitionSelectionConfig build() {
            return new CatalogCustomAttributeDefinitionSelectionConfig(this.maxAllowedSelections, this.allowedSelections, this.additionalProperties);
        }
    }
}

