/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CashDrawerShiftState;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CashDrawerShiftSummary {
    private final Optional<String> id;
    private final Optional<CashDrawerShiftState> state;
    private final Optional<String> openedAt;
    private final Optional<String> endedAt;
    private final Optional<String> closedAt;
    private final Optional<String> description;
    private final Optional<Money> openedCashMoney;
    private final Optional<Money> expectedCashMoney;
    private final Optional<Money> closedCashMoney;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> locationId;
    private final Map<String, Object> additionalProperties;

    private CashDrawerShiftSummary(Optional<String> id, Optional<CashDrawerShiftState> state, Optional<String> openedAt, Optional<String> endedAt, Optional<String> closedAt, Optional<String> description, Optional<Money> openedCashMoney, Optional<Money> expectedCashMoney, Optional<Money> closedCashMoney, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> locationId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.state = state;
        this.openedAt = openedAt;
        this.endedAt = endedAt;
        this.closedAt = closedAt;
        this.description = description;
        this.openedCashMoney = openedCashMoney;
        this.expectedCashMoney = expectedCashMoney;
        this.closedCashMoney = closedCashMoney;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.locationId = locationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="state")
    public Optional<CashDrawerShiftState> getState() {
        return this.state;
    }

    @JsonIgnore
    public Optional<String> getOpenedAt() {
        if (this.openedAt == null) {
            return Optional.empty();
        }
        return this.openedAt;
    }

    @JsonIgnore
    public Optional<String> getEndedAt() {
        if (this.endedAt == null) {
            return Optional.empty();
        }
        return this.endedAt;
    }

    @JsonIgnore
    public Optional<String> getClosedAt() {
        if (this.closedAt == null) {
            return Optional.empty();
        }
        return this.closedAt;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonProperty(value="opened_cash_money")
    public Optional<Money> getOpenedCashMoney() {
        return this.openedCashMoney;
    }

    @JsonProperty(value="expected_cash_money")
    public Optional<Money> getExpectedCashMoney() {
        return this.expectedCashMoney;
    }

    @JsonProperty(value="closed_cash_money")
    public Optional<Money> getClosedCashMoney() {
        return this.closedCashMoney;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="location_id")
    public Optional<String> getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="opened_at")
    private Optional<String> _getOpenedAt() {
        return this.openedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ended_at")
    private Optional<String> _getEndedAt() {
        return this.endedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="closed_at")
    private Optional<String> _getClosedAt() {
        return this.closedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CashDrawerShiftSummary && this.equalTo((CashDrawerShiftSummary)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CashDrawerShiftSummary other) {
        return this.id.equals(other.id) && this.state.equals(other.state) && this.openedAt.equals(other.openedAt) && this.endedAt.equals(other.endedAt) && this.closedAt.equals(other.closedAt) && this.description.equals(other.description) && this.openedCashMoney.equals(other.openedCashMoney) && this.expectedCashMoney.equals(other.expectedCashMoney) && this.closedCashMoney.equals(other.closedCashMoney) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.locationId.equals(other.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.description, this.openedCashMoney, this.expectedCashMoney, this.closedCashMoney, this.createdAt, this.updatedAt, this.locationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<CashDrawerShiftState> state = Optional.empty();
        private Optional<String> openedAt = Optional.empty();
        private Optional<String> endedAt = Optional.empty();
        private Optional<String> closedAt = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Money> openedCashMoney = Optional.empty();
        private Optional<Money> expectedCashMoney = Optional.empty();
        private Optional<Money> closedCashMoney = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CashDrawerShiftSummary other) {
            this.id(other.getId());
            this.state(other.getState());
            this.openedAt(other.getOpenedAt());
            this.endedAt(other.getEndedAt());
            this.closedAt(other.getClosedAt());
            this.description(other.getDescription());
            this.openedCashMoney(other.getOpenedCashMoney());
            this.expectedCashMoney(other.getExpectedCashMoney());
            this.closedCashMoney(other.getClosedCashMoney());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.locationId(other.getLocationId());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<CashDrawerShiftState> state) {
            this.state = state;
            return this;
        }

        public Builder state(CashDrawerShiftState state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="opened_at", nulls=Nulls.SKIP)
        public Builder openedAt(Optional<String> openedAt) {
            this.openedAt = openedAt;
            return this;
        }

        public Builder openedAt(String openedAt) {
            this.openedAt = Optional.ofNullable(openedAt);
            return this;
        }

        public Builder openedAt(Nullable<String> openedAt) {
            this.openedAt = openedAt.isNull() ? null : (openedAt.isEmpty() ? Optional.empty() : Optional.of(openedAt.get()));
            return this;
        }

        @JsonSetter(value="ended_at", nulls=Nulls.SKIP)
        public Builder endedAt(Optional<String> endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public Builder endedAt(String endedAt) {
            this.endedAt = Optional.ofNullable(endedAt);
            return this;
        }

        public Builder endedAt(Nullable<String> endedAt) {
            this.endedAt = endedAt.isNull() ? null : (endedAt.isEmpty() ? Optional.empty() : Optional.of(endedAt.get()));
            return this;
        }

        @JsonSetter(value="closed_at", nulls=Nulls.SKIP)
        public Builder closedAt(Optional<String> closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        public Builder closedAt(String closedAt) {
            this.closedAt = Optional.ofNullable(closedAt);
            return this;
        }

        public Builder closedAt(Nullable<String> closedAt) {
            this.closedAt = closedAt.isNull() ? null : (closedAt.isEmpty() ? Optional.empty() : Optional.of(closedAt.get()));
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @JsonSetter(value="opened_cash_money", nulls=Nulls.SKIP)
        public Builder openedCashMoney(Optional<Money> openedCashMoney) {
            this.openedCashMoney = openedCashMoney;
            return this;
        }

        public Builder openedCashMoney(Money openedCashMoney) {
            this.openedCashMoney = Optional.ofNullable(openedCashMoney);
            return this;
        }

        @JsonSetter(value="expected_cash_money", nulls=Nulls.SKIP)
        public Builder expectedCashMoney(Optional<Money> expectedCashMoney) {
            this.expectedCashMoney = expectedCashMoney;
            return this;
        }

        public Builder expectedCashMoney(Money expectedCashMoney) {
            this.expectedCashMoney = Optional.ofNullable(expectedCashMoney);
            return this;
        }

        @JsonSetter(value="closed_cash_money", nulls=Nulls.SKIP)
        public Builder closedCashMoney(Optional<Money> closedCashMoney) {
            this.closedCashMoney = closedCashMoney;
            return this;
        }

        public Builder closedCashMoney(Money closedCashMoney) {
            this.closedCashMoney = Optional.ofNullable(closedCashMoney);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public CashDrawerShiftSummary build() {
            return new CashDrawerShiftSummary(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.description, this.openedCashMoney, this.expectedCashMoney, this.closedCashMoney, this.createdAt, this.updatedAt, this.locationId, this.additionalProperties);
        }
    }
}

