/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class CashDrawerEventType {
    public static final CashDrawerEventType CASH_TENDER_PAYMENT = new CashDrawerEventType(Value.CASH_TENDER_PAYMENT, "CASH_TENDER_PAYMENT");
    public static final CashDrawerEventType OTHER_TENDER_PAYMENT = new CashDrawerEventType(Value.OTHER_TENDER_PAYMENT, "OTHER_TENDER_PAYMENT");
    public static final CashDrawerEventType OTHER_TENDER_CANCELLED_PAYMENT = new CashDrawerEventType(Value.OTHER_TENDER_CANCELLED_PAYMENT, "OTHER_TENDER_CANCELLED_PAYMENT");
    public static final CashDrawerEventType OTHER_TENDER_REFUND = new CashDrawerEventType(Value.OTHER_TENDER_REFUND, "OTHER_TENDER_REFUND");
    public static final CashDrawerEventType NO_SALE = new CashDrawerEventType(Value.NO_SALE, "NO_SALE");
    public static final CashDrawerEventType PAID_OUT = new CashDrawerEventType(Value.PAID_OUT, "PAID_OUT");
    public static final CashDrawerEventType CASH_TENDER_REFUND = new CashDrawerEventType(Value.CASH_TENDER_REFUND, "CASH_TENDER_REFUND");
    public static final CashDrawerEventType PAID_IN = new CashDrawerEventType(Value.PAID_IN, "PAID_IN");
    public static final CashDrawerEventType CASH_TENDER_CANCELLED_PAYMENT = new CashDrawerEventType(Value.CASH_TENDER_CANCELLED_PAYMENT, "CASH_TENDER_CANCELLED_PAYMENT");
    private final Value value;
    private final String string;

    CashDrawerEventType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CashDrawerEventType && this.string.equals(((CashDrawerEventType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CASH_TENDER_PAYMENT: {
                return visitor.visitCashTenderPayment();
            }
            case OTHER_TENDER_PAYMENT: {
                return visitor.visitOtherTenderPayment();
            }
            case OTHER_TENDER_CANCELLED_PAYMENT: {
                return visitor.visitOtherTenderCancelledPayment();
            }
            case OTHER_TENDER_REFUND: {
                return visitor.visitOtherTenderRefund();
            }
            case NO_SALE: {
                return visitor.visitNoSale();
            }
            case PAID_OUT: {
                return visitor.visitPaidOut();
            }
            case CASH_TENDER_REFUND: {
                return visitor.visitCashTenderRefund();
            }
            case PAID_IN: {
                return visitor.visitPaidIn();
            }
            case CASH_TENDER_CANCELLED_PAYMENT: {
                return visitor.visitCashTenderCancelledPayment();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static CashDrawerEventType valueOf(String value) {
        switch (value) {
            case "CASH_TENDER_PAYMENT": {
                return CASH_TENDER_PAYMENT;
            }
            case "OTHER_TENDER_PAYMENT": {
                return OTHER_TENDER_PAYMENT;
            }
            case "OTHER_TENDER_CANCELLED_PAYMENT": {
                return OTHER_TENDER_CANCELLED_PAYMENT;
            }
            case "OTHER_TENDER_REFUND": {
                return OTHER_TENDER_REFUND;
            }
            case "NO_SALE": {
                return NO_SALE;
            }
            case "PAID_OUT": {
                return PAID_OUT;
            }
            case "CASH_TENDER_REFUND": {
                return CASH_TENDER_REFUND;
            }
            case "PAID_IN": {
                return PAID_IN;
            }
            case "CASH_TENDER_CANCELLED_PAYMENT": {
                return CASH_TENDER_CANCELLED_PAYMENT;
            }
        }
        return new CashDrawerEventType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitNoSale();

        public T visitCashTenderPayment();

        public T visitOtherTenderPayment();

        public T visitCashTenderCancelledPayment();

        public T visitOtherTenderCancelledPayment();

        public T visitCashTenderRefund();

        public T visitOtherTenderRefund();

        public T visitPaidIn();

        public T visitPaidOut();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        NO_SALE,
        CASH_TENDER_PAYMENT,
        OTHER_TENDER_PAYMENT,
        CASH_TENDER_CANCELLED_PAYMENT,
        OTHER_TENDER_CANCELLED_PAYMENT,
        CASH_TENDER_REFUND,
        OTHER_TENDER_REFUND,
        PAID_IN,
        PAID_OUT,
        UNKNOWN;

    }
}

