/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CashAppDetails {
    private final Optional<String> buyerFullName;
    private final Optional<String> buyerCountryCode;
    private final Optional<String> buyerCashtag;
    private final Map<String, Object> additionalProperties;

    private CashAppDetails(Optional<String> buyerFullName, Optional<String> buyerCountryCode, Optional<String> buyerCashtag, Map<String, Object> additionalProperties) {
        this.buyerFullName = buyerFullName;
        this.buyerCountryCode = buyerCountryCode;
        this.buyerCashtag = buyerCashtag;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getBuyerFullName() {
        if (this.buyerFullName == null) {
            return Optional.empty();
        }
        return this.buyerFullName;
    }

    @JsonIgnore
    public Optional<String> getBuyerCountryCode() {
        if (this.buyerCountryCode == null) {
            return Optional.empty();
        }
        return this.buyerCountryCode;
    }

    @JsonProperty(value="buyer_cashtag")
    public Optional<String> getBuyerCashtag() {
        return this.buyerCashtag;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="buyer_full_name")
    private Optional<String> _getBuyerFullName() {
        return this.buyerFullName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="buyer_country_code")
    private Optional<String> _getBuyerCountryCode() {
        return this.buyerCountryCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CashAppDetails && this.equalTo((CashAppDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CashAppDetails other) {
        return this.buyerFullName.equals(other.buyerFullName) && this.buyerCountryCode.equals(other.buyerCountryCode) && this.buyerCashtag.equals(other.buyerCashtag);
    }

    public int hashCode() {
        return Objects.hash(this.buyerFullName, this.buyerCountryCode, this.buyerCashtag);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> buyerFullName = Optional.empty();
        private Optional<String> buyerCountryCode = Optional.empty();
        private Optional<String> buyerCashtag = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CashAppDetails other) {
            this.buyerFullName(other.getBuyerFullName());
            this.buyerCountryCode(other.getBuyerCountryCode());
            this.buyerCashtag(other.getBuyerCashtag());
            return this;
        }

        @JsonSetter(value="buyer_full_name", nulls=Nulls.SKIP)
        public Builder buyerFullName(Optional<String> buyerFullName) {
            this.buyerFullName = buyerFullName;
            return this;
        }

        public Builder buyerFullName(String buyerFullName) {
            this.buyerFullName = Optional.ofNullable(buyerFullName);
            return this;
        }

        public Builder buyerFullName(Nullable<String> buyerFullName) {
            this.buyerFullName = buyerFullName.isNull() ? null : (buyerFullName.isEmpty() ? Optional.empty() : Optional.of(buyerFullName.get()));
            return this;
        }

        @JsonSetter(value="buyer_country_code", nulls=Nulls.SKIP)
        public Builder buyerCountryCode(Optional<String> buyerCountryCode) {
            this.buyerCountryCode = buyerCountryCode;
            return this;
        }

        public Builder buyerCountryCode(String buyerCountryCode) {
            this.buyerCountryCode = Optional.ofNullable(buyerCountryCode);
            return this;
        }

        public Builder buyerCountryCode(Nullable<String> buyerCountryCode) {
            this.buyerCountryCode = buyerCountryCode.isNull() ? null : (buyerCountryCode.isEmpty() ? Optional.empty() : Optional.of(buyerCountryCode.get()));
            return this;
        }

        @JsonSetter(value="buyer_cashtag", nulls=Nulls.SKIP)
        public Builder buyerCashtag(Optional<String> buyerCashtag) {
            this.buyerCashtag = buyerCashtag;
            return this;
        }

        public Builder buyerCashtag(String buyerCashtag) {
            this.buyerCashtag = Optional.ofNullable(buyerCashtag);
            return this;
        }

        public CashAppDetails build() {
            return new CashAppDetails(this.buyerFullName, this.buyerCountryCode, this.buyerCashtag, this.additionalProperties);
        }
    }
}

