/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class CardType {
    public static final CardType CREDIT = new CardType(Value.CREDIT, "CREDIT");
    public static final CardType UNKNOWN_CARD_TYPE = new CardType(Value.UNKNOWN_CARD_TYPE, "UNKNOWN_CARD_TYPE");
    public static final CardType DEBIT = new CardType(Value.DEBIT, "DEBIT");
    private final Value value;
    private final String string;

    CardType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CardType && this.string.equals(((CardType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CREDIT: {
                return visitor.visitCredit();
            }
            case UNKNOWN_CARD_TYPE: {
                return visitor.visitUnknownCardType();
            }
            case DEBIT: {
                return visitor.visitDebit();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static CardType valueOf(String value) {
        switch (value) {
            case "CREDIT": {
                return CREDIT;
            }
            case "UNKNOWN_CARD_TYPE": {
                return UNKNOWN_CARD_TYPE;
            }
            case "DEBIT": {
                return DEBIT;
            }
        }
        return new CardType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitUnknownCardType();

        public T visitCredit();

        public T visitDebit();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        UNKNOWN_CARD_TYPE,
        CREDIT,
        DEBIT,
        UNKNOWN;

    }
}

