/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CardPaymentTimeline {
    private final Optional<String> authorizedAt;
    private final Optional<String> capturedAt;
    private final Optional<String> voidedAt;
    private final Map<String, Object> additionalProperties;

    private CardPaymentTimeline(Optional<String> authorizedAt, Optional<String> capturedAt, Optional<String> voidedAt, Map<String, Object> additionalProperties) {
        this.authorizedAt = authorizedAt;
        this.capturedAt = capturedAt;
        this.voidedAt = voidedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getAuthorizedAt() {
        if (this.authorizedAt == null) {
            return Optional.empty();
        }
        return this.authorizedAt;
    }

    @JsonIgnore
    public Optional<String> getCapturedAt() {
        if (this.capturedAt == null) {
            return Optional.empty();
        }
        return this.capturedAt;
    }

    @JsonIgnore
    public Optional<String> getVoidedAt() {
        if (this.voidedAt == null) {
            return Optional.empty();
        }
        return this.voidedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="authorized_at")
    private Optional<String> _getAuthorizedAt() {
        return this.authorizedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="captured_at")
    private Optional<String> _getCapturedAt() {
        return this.capturedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="voided_at")
    private Optional<String> _getVoidedAt() {
        return this.voidedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CardPaymentTimeline && this.equalTo((CardPaymentTimeline)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CardPaymentTimeline other) {
        return this.authorizedAt.equals(other.authorizedAt) && this.capturedAt.equals(other.capturedAt) && this.voidedAt.equals(other.voidedAt);
    }

    public int hashCode() {
        return Objects.hash(this.authorizedAt, this.capturedAt, this.voidedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> authorizedAt = Optional.empty();
        private Optional<String> capturedAt = Optional.empty();
        private Optional<String> voidedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CardPaymentTimeline other) {
            this.authorizedAt(other.getAuthorizedAt());
            this.capturedAt(other.getCapturedAt());
            this.voidedAt(other.getVoidedAt());
            return this;
        }

        @JsonSetter(value="authorized_at", nulls=Nulls.SKIP)
        public Builder authorizedAt(Optional<String> authorizedAt) {
            this.authorizedAt = authorizedAt;
            return this;
        }

        public Builder authorizedAt(String authorizedAt) {
            this.authorizedAt = Optional.ofNullable(authorizedAt);
            return this;
        }

        public Builder authorizedAt(Nullable<String> authorizedAt) {
            this.authorizedAt = authorizedAt.isNull() ? null : (authorizedAt.isEmpty() ? Optional.empty() : Optional.of(authorizedAt.get()));
            return this;
        }

        @JsonSetter(value="captured_at", nulls=Nulls.SKIP)
        public Builder capturedAt(Optional<String> capturedAt) {
            this.capturedAt = capturedAt;
            return this;
        }

        public Builder capturedAt(String capturedAt) {
            this.capturedAt = Optional.ofNullable(capturedAt);
            return this;
        }

        public Builder capturedAt(Nullable<String> capturedAt) {
            this.capturedAt = capturedAt.isNull() ? null : (capturedAt.isEmpty() ? Optional.empty() : Optional.of(capturedAt.get()));
            return this;
        }

        @JsonSetter(value="voided_at", nulls=Nulls.SKIP)
        public Builder voidedAt(Optional<String> voidedAt) {
            this.voidedAt = voidedAt;
            return this;
        }

        public Builder voidedAt(String voidedAt) {
            this.voidedAt = Optional.ofNullable(voidedAt);
            return this;
        }

        public Builder voidedAt(Nullable<String> voidedAt) {
            this.voidedAt = voidedAt.isNull() ? null : (voidedAt.isEmpty() ? Optional.empty() : Optional.of(voidedAt.get()));
            return this;
        }

        public CardPaymentTimeline build() {
            return new CardPaymentTimeline(this.authorizedAt, this.capturedAt, this.voidedAt, this.additionalProperties);
        }
    }
}

