/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CancelPaymentsRequest {
    private final String paymentId;
    private final Map<String, Object> additionalProperties;

    private CancelPaymentsRequest(String paymentId, Map<String, Object> additionalProperties) {
        this.paymentId = paymentId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="payment_id")
    public String getPaymentId() {
        return this.paymentId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CancelPaymentsRequest && this.equalTo((CancelPaymentsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CancelPaymentsRequest other) {
        return this.paymentId.equals(other.paymentId);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PaymentIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PaymentIdStage,
    _FinalStage {
        private String paymentId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CancelPaymentsRequest other) {
            this.paymentId(other.getPaymentId());
            return this;
        }

        @Override
        @JsonSetter(value="payment_id")
        public _FinalStage paymentId(@NotNull String paymentId) {
            this.paymentId = Objects.requireNonNull(paymentId, "paymentId must not be null");
            return this;
        }

        @Override
        public CancelPaymentsRequest build() {
            return new CancelPaymentsRequest(this.paymentId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CancelPaymentsRequest build();
    }

    public static interface PaymentIdStage {
        public _FinalStage paymentId(@NotNull String var1);

        public Builder from(CancelPaymentsRequest var1);
    }
}

