/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CancelInvoiceRequest {
    private final String invoiceId;
    private final int version;
    private final Map<String, Object> additionalProperties;

    private CancelInvoiceRequest(String invoiceId, int version, Map<String, Object> additionalProperties) {
        this.invoiceId = invoiceId;
        this.version = version;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="invoice_id")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CancelInvoiceRequest && this.equalTo((CancelInvoiceRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CancelInvoiceRequest other) {
        return this.invoiceId.equals(other.invoiceId) && this.version == other.version;
    }

    public int hashCode() {
        return Objects.hash(this.invoiceId, this.version);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InvoiceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements InvoiceIdStage,
    VersionStage,
    _FinalStage {
        private String invoiceId;
        private int version;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CancelInvoiceRequest other) {
            this.invoiceId(other.getInvoiceId());
            this.version(other.getVersion());
            return this;
        }

        @Override
        @JsonSetter(value="invoice_id")
        public VersionStage invoiceId(@NotNull String invoiceId) {
            this.invoiceId = Objects.requireNonNull(invoiceId, "invoiceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="version")
        public _FinalStage version(int version) {
            this.version = version;
            return this;
        }

        @Override
        public CancelInvoiceRequest build() {
            return new CancelInvoiceRequest(this.invoiceId, this.version, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CancelInvoiceRequest build();
    }

    public static interface VersionStage {
        public _FinalStage version(int var1);
    }

    public static interface InvoiceIdStage {
        public VersionStage invoiceId(@NotNull String var1);

        public Builder from(CancelInvoiceRequest var1);
    }
}

