/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CancelBookingRequest {
    private final String bookingId;
    private final Optional<String> idempotencyKey;
    private final Optional<Integer> bookingVersion;
    private final Map<String, Object> additionalProperties;

    private CancelBookingRequest(String bookingId, Optional<String> idempotencyKey, Optional<Integer> bookingVersion, Map<String, Object> additionalProperties) {
        this.bookingId = bookingId;
        this.idempotencyKey = idempotencyKey;
        this.bookingVersion = bookingVersion;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="booking_id")
    public String getBookingId() {
        return this.bookingId;
    }

    @JsonIgnore
    public Optional<String> getIdempotencyKey() {
        if (this.idempotencyKey == null) {
            return Optional.empty();
        }
        return this.idempotencyKey;
    }

    @JsonIgnore
    public Optional<Integer> getBookingVersion() {
        if (this.bookingVersion == null) {
            return Optional.empty();
        }
        return this.bookingVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="idempotency_key")
    private Optional<String> _getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="booking_version")
    private Optional<Integer> _getBookingVersion() {
        return this.bookingVersion;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CancelBookingRequest && this.equalTo((CancelBookingRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CancelBookingRequest other) {
        return this.bookingId.equals(other.bookingId) && this.idempotencyKey.equals(other.idempotencyKey) && this.bookingVersion.equals(other.bookingVersion);
    }

    public int hashCode() {
        return Objects.hash(this.bookingId, this.idempotencyKey, this.bookingVersion);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BookingIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BookingIdStage,
    _FinalStage {
        private String bookingId;
        private Optional<Integer> bookingVersion = Optional.empty();
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CancelBookingRequest other) {
            this.bookingId(other.getBookingId());
            this.idempotencyKey(other.getIdempotencyKey());
            this.bookingVersion(other.getBookingVersion());
            return this;
        }

        @Override
        @JsonSetter(value="booking_id")
        public _FinalStage bookingId(@NotNull String bookingId) {
            this.bookingId = Objects.requireNonNull(bookingId, "bookingId must not be null");
            return this;
        }

        @Override
        public _FinalStage bookingVersion(Nullable<Integer> bookingVersion) {
            this.bookingVersion = bookingVersion.isNull() ? null : (bookingVersion.isEmpty() ? Optional.empty() : Optional.of(bookingVersion.get()));
            return this;
        }

        @Override
        public _FinalStage bookingVersion(Integer bookingVersion) {
            this.bookingVersion = Optional.ofNullable(bookingVersion);
            return this;
        }

        @Override
        @JsonSetter(value="booking_version", nulls=Nulls.SKIP)
        public _FinalStage bookingVersion(Optional<Integer> bookingVersion) {
            this.bookingVersion = bookingVersion;
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(Nullable<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey.isNull() ? null : (idempotencyKey.isEmpty() ? Optional.empty() : Optional.of(idempotencyKey.get()));
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public CancelBookingRequest build() {
            return new CancelBookingRequest(this.bookingId, this.idempotencyKey, this.bookingVersion, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CancelBookingRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);

        public _FinalStage idempotencyKey(Nullable<String> var1);

        public _FinalStage bookingVersion(Optional<Integer> var1);

        public _FinalStage bookingVersion(Integer var1);

        public _FinalStage bookingVersion(Nullable<Integer> var1);
    }

    public static interface BookingIdStage {
        public _FinalStage bookingId(@NotNull String var1);

        public Builder from(CancelBookingRequest var1);
    }
}

