/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.AfterpayDetails;
import com.squareup.square.types.ClearpayDetails;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BuyNowPayLaterDetails {
    private final Optional<String> brand;
    private final Optional<AfterpayDetails> afterpayDetails;
    private final Optional<ClearpayDetails> clearpayDetails;
    private final Map<String, Object> additionalProperties;

    private BuyNowPayLaterDetails(Optional<String> brand, Optional<AfterpayDetails> afterpayDetails, Optional<ClearpayDetails> clearpayDetails, Map<String, Object> additionalProperties) {
        this.brand = brand;
        this.afterpayDetails = afterpayDetails;
        this.clearpayDetails = clearpayDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getBrand() {
        if (this.brand == null) {
            return Optional.empty();
        }
        return this.brand;
    }

    @JsonProperty(value="afterpay_details")
    public Optional<AfterpayDetails> getAfterpayDetails() {
        return this.afterpayDetails;
    }

    @JsonProperty(value="clearpay_details")
    public Optional<ClearpayDetails> getClearpayDetails() {
        return this.clearpayDetails;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="brand")
    private Optional<String> _getBrand() {
        return this.brand;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BuyNowPayLaterDetails && this.equalTo((BuyNowPayLaterDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BuyNowPayLaterDetails other) {
        return this.brand.equals(other.brand) && this.afterpayDetails.equals(other.afterpayDetails) && this.clearpayDetails.equals(other.clearpayDetails);
    }

    public int hashCode() {
        return Objects.hash(this.brand, this.afterpayDetails, this.clearpayDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> brand = Optional.empty();
        private Optional<AfterpayDetails> afterpayDetails = Optional.empty();
        private Optional<ClearpayDetails> clearpayDetails = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BuyNowPayLaterDetails other) {
            this.brand(other.getBrand());
            this.afterpayDetails(other.getAfterpayDetails());
            this.clearpayDetails(other.getClearpayDetails());
            return this;
        }

        @JsonSetter(value="brand", nulls=Nulls.SKIP)
        public Builder brand(Optional<String> brand) {
            this.brand = brand;
            return this;
        }

        public Builder brand(String brand) {
            this.brand = Optional.ofNullable(brand);
            return this;
        }

        public Builder brand(Nullable<String> brand) {
            this.brand = brand.isNull() ? null : (brand.isEmpty() ? Optional.empty() : Optional.of(brand.get()));
            return this;
        }

        @JsonSetter(value="afterpay_details", nulls=Nulls.SKIP)
        public Builder afterpayDetails(Optional<AfterpayDetails> afterpayDetails) {
            this.afterpayDetails = afterpayDetails;
            return this;
        }

        public Builder afterpayDetails(AfterpayDetails afterpayDetails) {
            this.afterpayDetails = Optional.ofNullable(afterpayDetails);
            return this;
        }

        @JsonSetter(value="clearpay_details", nulls=Nulls.SKIP)
        public Builder clearpayDetails(Optional<ClearpayDetails> clearpayDetails) {
            this.clearpayDetails = clearpayDetails;
            return this;
        }

        public Builder clearpayDetails(ClearpayDetails clearpayDetails) {
            this.clearpayDetails = Optional.ofNullable(clearpayDetails);
            return this;
        }

        public BuyNowPayLaterDetails build() {
            return new BuyNowPayLaterDetails(this.brand, this.afterpayDetails, this.clearpayDetails, this.additionalProperties);
        }
    }
}

