/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BusinessAppointmentSettingsAlignmentTime;
import com.squareup.square.types.BusinessAppointmentSettingsBookingLocationType;
import com.squareup.square.types.BusinessAppointmentSettingsCancellationPolicy;
import com.squareup.square.types.BusinessAppointmentSettingsMaxAppointmentsPerDayLimitType;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BusinessAppointmentSettings {
    private final Optional<List<BusinessAppointmentSettingsBookingLocationType>> locationTypes;
    private final Optional<BusinessAppointmentSettingsAlignmentTime> alignmentTime;
    private final Optional<Integer> minBookingLeadTimeSeconds;
    private final Optional<Integer> maxBookingLeadTimeSeconds;
    private final Optional<Boolean> anyTeamMemberBookingEnabled;
    private final Optional<Boolean> multipleServiceBookingEnabled;
    private final Optional<BusinessAppointmentSettingsMaxAppointmentsPerDayLimitType> maxAppointmentsPerDayLimitType;
    private final Optional<Integer> maxAppointmentsPerDayLimit;
    private final Optional<Integer> cancellationWindowSeconds;
    private final Optional<Money> cancellationFeeMoney;
    private final Optional<BusinessAppointmentSettingsCancellationPolicy> cancellationPolicy;
    private final Optional<String> cancellationPolicyText;
    private final Optional<Boolean> skipBookingFlowStaffSelection;
    private final Map<String, Object> additionalProperties;

    private BusinessAppointmentSettings(Optional<List<BusinessAppointmentSettingsBookingLocationType>> locationTypes, Optional<BusinessAppointmentSettingsAlignmentTime> alignmentTime, Optional<Integer> minBookingLeadTimeSeconds, Optional<Integer> maxBookingLeadTimeSeconds, Optional<Boolean> anyTeamMemberBookingEnabled, Optional<Boolean> multipleServiceBookingEnabled, Optional<BusinessAppointmentSettingsMaxAppointmentsPerDayLimitType> maxAppointmentsPerDayLimitType, Optional<Integer> maxAppointmentsPerDayLimit, Optional<Integer> cancellationWindowSeconds, Optional<Money> cancellationFeeMoney, Optional<BusinessAppointmentSettingsCancellationPolicy> cancellationPolicy, Optional<String> cancellationPolicyText, Optional<Boolean> skipBookingFlowStaffSelection, Map<String, Object> additionalProperties) {
        this.locationTypes = locationTypes;
        this.alignmentTime = alignmentTime;
        this.minBookingLeadTimeSeconds = minBookingLeadTimeSeconds;
        this.maxBookingLeadTimeSeconds = maxBookingLeadTimeSeconds;
        this.anyTeamMemberBookingEnabled = anyTeamMemberBookingEnabled;
        this.multipleServiceBookingEnabled = multipleServiceBookingEnabled;
        this.maxAppointmentsPerDayLimitType = maxAppointmentsPerDayLimitType;
        this.maxAppointmentsPerDayLimit = maxAppointmentsPerDayLimit;
        this.cancellationWindowSeconds = cancellationWindowSeconds;
        this.cancellationFeeMoney = cancellationFeeMoney;
        this.cancellationPolicy = cancellationPolicy;
        this.cancellationPolicyText = cancellationPolicyText;
        this.skipBookingFlowStaffSelection = skipBookingFlowStaffSelection;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<BusinessAppointmentSettingsBookingLocationType>> getLocationTypes() {
        if (this.locationTypes == null) {
            return Optional.empty();
        }
        return this.locationTypes;
    }

    @JsonProperty(value="alignment_time")
    public Optional<BusinessAppointmentSettingsAlignmentTime> getAlignmentTime() {
        return this.alignmentTime;
    }

    @JsonIgnore
    public Optional<Integer> getMinBookingLeadTimeSeconds() {
        if (this.minBookingLeadTimeSeconds == null) {
            return Optional.empty();
        }
        return this.minBookingLeadTimeSeconds;
    }

    @JsonIgnore
    public Optional<Integer> getMaxBookingLeadTimeSeconds() {
        if (this.maxBookingLeadTimeSeconds == null) {
            return Optional.empty();
        }
        return this.maxBookingLeadTimeSeconds;
    }

    @JsonIgnore
    public Optional<Boolean> getAnyTeamMemberBookingEnabled() {
        if (this.anyTeamMemberBookingEnabled == null) {
            return Optional.empty();
        }
        return this.anyTeamMemberBookingEnabled;
    }

    @JsonIgnore
    public Optional<Boolean> getMultipleServiceBookingEnabled() {
        if (this.multipleServiceBookingEnabled == null) {
            return Optional.empty();
        }
        return this.multipleServiceBookingEnabled;
    }

    @JsonProperty(value="max_appointments_per_day_limit_type")
    public Optional<BusinessAppointmentSettingsMaxAppointmentsPerDayLimitType> getMaxAppointmentsPerDayLimitType() {
        return this.maxAppointmentsPerDayLimitType;
    }

    @JsonIgnore
    public Optional<Integer> getMaxAppointmentsPerDayLimit() {
        if (this.maxAppointmentsPerDayLimit == null) {
            return Optional.empty();
        }
        return this.maxAppointmentsPerDayLimit;
    }

    @JsonIgnore
    public Optional<Integer> getCancellationWindowSeconds() {
        if (this.cancellationWindowSeconds == null) {
            return Optional.empty();
        }
        return this.cancellationWindowSeconds;
    }

    @JsonProperty(value="cancellation_fee_money")
    public Optional<Money> getCancellationFeeMoney() {
        return this.cancellationFeeMoney;
    }

    @JsonProperty(value="cancellation_policy")
    public Optional<BusinessAppointmentSettingsCancellationPolicy> getCancellationPolicy() {
        return this.cancellationPolicy;
    }

    @JsonIgnore
    public Optional<String> getCancellationPolicyText() {
        if (this.cancellationPolicyText == null) {
            return Optional.empty();
        }
        return this.cancellationPolicyText;
    }

    @JsonIgnore
    public Optional<Boolean> getSkipBookingFlowStaffSelection() {
        if (this.skipBookingFlowStaffSelection == null) {
            return Optional.empty();
        }
        return this.skipBookingFlowStaffSelection;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_types")
    private Optional<List<BusinessAppointmentSettingsBookingLocationType>> _getLocationTypes() {
        return this.locationTypes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="min_booking_lead_time_seconds")
    private Optional<Integer> _getMinBookingLeadTimeSeconds() {
        return this.minBookingLeadTimeSeconds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="max_booking_lead_time_seconds")
    private Optional<Integer> _getMaxBookingLeadTimeSeconds() {
        return this.maxBookingLeadTimeSeconds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="any_team_member_booking_enabled")
    private Optional<Boolean> _getAnyTeamMemberBookingEnabled() {
        return this.anyTeamMemberBookingEnabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="multiple_service_booking_enabled")
    private Optional<Boolean> _getMultipleServiceBookingEnabled() {
        return this.multipleServiceBookingEnabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="max_appointments_per_day_limit")
    private Optional<Integer> _getMaxAppointmentsPerDayLimit() {
        return this.maxAppointmentsPerDayLimit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cancellation_window_seconds")
    private Optional<Integer> _getCancellationWindowSeconds() {
        return this.cancellationWindowSeconds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cancellation_policy_text")
    private Optional<String> _getCancellationPolicyText() {
        return this.cancellationPolicyText;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="skip_booking_flow_staff_selection")
    private Optional<Boolean> _getSkipBookingFlowStaffSelection() {
        return this.skipBookingFlowStaffSelection;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BusinessAppointmentSettings && this.equalTo((BusinessAppointmentSettings)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BusinessAppointmentSettings other) {
        return this.locationTypes.equals(other.locationTypes) && this.alignmentTime.equals(other.alignmentTime) && this.minBookingLeadTimeSeconds.equals(other.minBookingLeadTimeSeconds) && this.maxBookingLeadTimeSeconds.equals(other.maxBookingLeadTimeSeconds) && this.anyTeamMemberBookingEnabled.equals(other.anyTeamMemberBookingEnabled) && this.multipleServiceBookingEnabled.equals(other.multipleServiceBookingEnabled) && this.maxAppointmentsPerDayLimitType.equals(other.maxAppointmentsPerDayLimitType) && this.maxAppointmentsPerDayLimit.equals(other.maxAppointmentsPerDayLimit) && this.cancellationWindowSeconds.equals(other.cancellationWindowSeconds) && this.cancellationFeeMoney.equals(other.cancellationFeeMoney) && this.cancellationPolicy.equals(other.cancellationPolicy) && this.cancellationPolicyText.equals(other.cancellationPolicyText) && this.skipBookingFlowStaffSelection.equals(other.skipBookingFlowStaffSelection);
    }

    public int hashCode() {
        return Objects.hash(this.locationTypes, this.alignmentTime, this.minBookingLeadTimeSeconds, this.maxBookingLeadTimeSeconds, this.anyTeamMemberBookingEnabled, this.multipleServiceBookingEnabled, this.maxAppointmentsPerDayLimitType, this.maxAppointmentsPerDayLimit, this.cancellationWindowSeconds, this.cancellationFeeMoney, this.cancellationPolicy, this.cancellationPolicyText, this.skipBookingFlowStaffSelection);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<BusinessAppointmentSettingsBookingLocationType>> locationTypes = Optional.empty();
        private Optional<BusinessAppointmentSettingsAlignmentTime> alignmentTime = Optional.empty();
        private Optional<Integer> minBookingLeadTimeSeconds = Optional.empty();
        private Optional<Integer> maxBookingLeadTimeSeconds = Optional.empty();
        private Optional<Boolean> anyTeamMemberBookingEnabled = Optional.empty();
        private Optional<Boolean> multipleServiceBookingEnabled = Optional.empty();
        private Optional<BusinessAppointmentSettingsMaxAppointmentsPerDayLimitType> maxAppointmentsPerDayLimitType = Optional.empty();
        private Optional<Integer> maxAppointmentsPerDayLimit = Optional.empty();
        private Optional<Integer> cancellationWindowSeconds = Optional.empty();
        private Optional<Money> cancellationFeeMoney = Optional.empty();
        private Optional<BusinessAppointmentSettingsCancellationPolicy> cancellationPolicy = Optional.empty();
        private Optional<String> cancellationPolicyText = Optional.empty();
        private Optional<Boolean> skipBookingFlowStaffSelection = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BusinessAppointmentSettings other) {
            this.locationTypes(other.getLocationTypes());
            this.alignmentTime(other.getAlignmentTime());
            this.minBookingLeadTimeSeconds(other.getMinBookingLeadTimeSeconds());
            this.maxBookingLeadTimeSeconds(other.getMaxBookingLeadTimeSeconds());
            this.anyTeamMemberBookingEnabled(other.getAnyTeamMemberBookingEnabled());
            this.multipleServiceBookingEnabled(other.getMultipleServiceBookingEnabled());
            this.maxAppointmentsPerDayLimitType(other.getMaxAppointmentsPerDayLimitType());
            this.maxAppointmentsPerDayLimit(other.getMaxAppointmentsPerDayLimit());
            this.cancellationWindowSeconds(other.getCancellationWindowSeconds());
            this.cancellationFeeMoney(other.getCancellationFeeMoney());
            this.cancellationPolicy(other.getCancellationPolicy());
            this.cancellationPolicyText(other.getCancellationPolicyText());
            this.skipBookingFlowStaffSelection(other.getSkipBookingFlowStaffSelection());
            return this;
        }

        @JsonSetter(value="location_types", nulls=Nulls.SKIP)
        public Builder locationTypes(Optional<List<BusinessAppointmentSettingsBookingLocationType>> locationTypes) {
            this.locationTypes = locationTypes;
            return this;
        }

        public Builder locationTypes(List<BusinessAppointmentSettingsBookingLocationType> locationTypes) {
            this.locationTypes = Optional.ofNullable(locationTypes);
            return this;
        }

        public Builder locationTypes(Nullable<List<BusinessAppointmentSettingsBookingLocationType>> locationTypes) {
            this.locationTypes = locationTypes.isNull() ? null : (locationTypes.isEmpty() ? Optional.empty() : Optional.of(locationTypes.get()));
            return this;
        }

        @JsonSetter(value="alignment_time", nulls=Nulls.SKIP)
        public Builder alignmentTime(Optional<BusinessAppointmentSettingsAlignmentTime> alignmentTime) {
            this.alignmentTime = alignmentTime;
            return this;
        }

        public Builder alignmentTime(BusinessAppointmentSettingsAlignmentTime alignmentTime) {
            this.alignmentTime = Optional.ofNullable(alignmentTime);
            return this;
        }

        @JsonSetter(value="min_booking_lead_time_seconds", nulls=Nulls.SKIP)
        public Builder minBookingLeadTimeSeconds(Optional<Integer> minBookingLeadTimeSeconds) {
            this.minBookingLeadTimeSeconds = minBookingLeadTimeSeconds;
            return this;
        }

        public Builder minBookingLeadTimeSeconds(Integer minBookingLeadTimeSeconds) {
            this.minBookingLeadTimeSeconds = Optional.ofNullable(minBookingLeadTimeSeconds);
            return this;
        }

        public Builder minBookingLeadTimeSeconds(Nullable<Integer> minBookingLeadTimeSeconds) {
            this.minBookingLeadTimeSeconds = minBookingLeadTimeSeconds.isNull() ? null : (minBookingLeadTimeSeconds.isEmpty() ? Optional.empty() : Optional.of(minBookingLeadTimeSeconds.get()));
            return this;
        }

        @JsonSetter(value="max_booking_lead_time_seconds", nulls=Nulls.SKIP)
        public Builder maxBookingLeadTimeSeconds(Optional<Integer> maxBookingLeadTimeSeconds) {
            this.maxBookingLeadTimeSeconds = maxBookingLeadTimeSeconds;
            return this;
        }

        public Builder maxBookingLeadTimeSeconds(Integer maxBookingLeadTimeSeconds) {
            this.maxBookingLeadTimeSeconds = Optional.ofNullable(maxBookingLeadTimeSeconds);
            return this;
        }

        public Builder maxBookingLeadTimeSeconds(Nullable<Integer> maxBookingLeadTimeSeconds) {
            this.maxBookingLeadTimeSeconds = maxBookingLeadTimeSeconds.isNull() ? null : (maxBookingLeadTimeSeconds.isEmpty() ? Optional.empty() : Optional.of(maxBookingLeadTimeSeconds.get()));
            return this;
        }

        @JsonSetter(value="any_team_member_booking_enabled", nulls=Nulls.SKIP)
        public Builder anyTeamMemberBookingEnabled(Optional<Boolean> anyTeamMemberBookingEnabled) {
            this.anyTeamMemberBookingEnabled = anyTeamMemberBookingEnabled;
            return this;
        }

        public Builder anyTeamMemberBookingEnabled(Boolean anyTeamMemberBookingEnabled) {
            this.anyTeamMemberBookingEnabled = Optional.ofNullable(anyTeamMemberBookingEnabled);
            return this;
        }

        public Builder anyTeamMemberBookingEnabled(Nullable<Boolean> anyTeamMemberBookingEnabled) {
            this.anyTeamMemberBookingEnabled = anyTeamMemberBookingEnabled.isNull() ? null : (anyTeamMemberBookingEnabled.isEmpty() ? Optional.empty() : Optional.of(anyTeamMemberBookingEnabled.get()));
            return this;
        }

        @JsonSetter(value="multiple_service_booking_enabled", nulls=Nulls.SKIP)
        public Builder multipleServiceBookingEnabled(Optional<Boolean> multipleServiceBookingEnabled) {
            this.multipleServiceBookingEnabled = multipleServiceBookingEnabled;
            return this;
        }

        public Builder multipleServiceBookingEnabled(Boolean multipleServiceBookingEnabled) {
            this.multipleServiceBookingEnabled = Optional.ofNullable(multipleServiceBookingEnabled);
            return this;
        }

        public Builder multipleServiceBookingEnabled(Nullable<Boolean> multipleServiceBookingEnabled) {
            this.multipleServiceBookingEnabled = multipleServiceBookingEnabled.isNull() ? null : (multipleServiceBookingEnabled.isEmpty() ? Optional.empty() : Optional.of(multipleServiceBookingEnabled.get()));
            return this;
        }

        @JsonSetter(value="max_appointments_per_day_limit_type", nulls=Nulls.SKIP)
        public Builder maxAppointmentsPerDayLimitType(Optional<BusinessAppointmentSettingsMaxAppointmentsPerDayLimitType> maxAppointmentsPerDayLimitType) {
            this.maxAppointmentsPerDayLimitType = maxAppointmentsPerDayLimitType;
            return this;
        }

        public Builder maxAppointmentsPerDayLimitType(BusinessAppointmentSettingsMaxAppointmentsPerDayLimitType maxAppointmentsPerDayLimitType) {
            this.maxAppointmentsPerDayLimitType = Optional.ofNullable(maxAppointmentsPerDayLimitType);
            return this;
        }

        @JsonSetter(value="max_appointments_per_day_limit", nulls=Nulls.SKIP)
        public Builder maxAppointmentsPerDayLimit(Optional<Integer> maxAppointmentsPerDayLimit) {
            this.maxAppointmentsPerDayLimit = maxAppointmentsPerDayLimit;
            return this;
        }

        public Builder maxAppointmentsPerDayLimit(Integer maxAppointmentsPerDayLimit) {
            this.maxAppointmentsPerDayLimit = Optional.ofNullable(maxAppointmentsPerDayLimit);
            return this;
        }

        public Builder maxAppointmentsPerDayLimit(Nullable<Integer> maxAppointmentsPerDayLimit) {
            this.maxAppointmentsPerDayLimit = maxAppointmentsPerDayLimit.isNull() ? null : (maxAppointmentsPerDayLimit.isEmpty() ? Optional.empty() : Optional.of(maxAppointmentsPerDayLimit.get()));
            return this;
        }

        @JsonSetter(value="cancellation_window_seconds", nulls=Nulls.SKIP)
        public Builder cancellationWindowSeconds(Optional<Integer> cancellationWindowSeconds) {
            this.cancellationWindowSeconds = cancellationWindowSeconds;
            return this;
        }

        public Builder cancellationWindowSeconds(Integer cancellationWindowSeconds) {
            this.cancellationWindowSeconds = Optional.ofNullable(cancellationWindowSeconds);
            return this;
        }

        public Builder cancellationWindowSeconds(Nullable<Integer> cancellationWindowSeconds) {
            this.cancellationWindowSeconds = cancellationWindowSeconds.isNull() ? null : (cancellationWindowSeconds.isEmpty() ? Optional.empty() : Optional.of(cancellationWindowSeconds.get()));
            return this;
        }

        @JsonSetter(value="cancellation_fee_money", nulls=Nulls.SKIP)
        public Builder cancellationFeeMoney(Optional<Money> cancellationFeeMoney) {
            this.cancellationFeeMoney = cancellationFeeMoney;
            return this;
        }

        public Builder cancellationFeeMoney(Money cancellationFeeMoney) {
            this.cancellationFeeMoney = Optional.ofNullable(cancellationFeeMoney);
            return this;
        }

        @JsonSetter(value="cancellation_policy", nulls=Nulls.SKIP)
        public Builder cancellationPolicy(Optional<BusinessAppointmentSettingsCancellationPolicy> cancellationPolicy) {
            this.cancellationPolicy = cancellationPolicy;
            return this;
        }

        public Builder cancellationPolicy(BusinessAppointmentSettingsCancellationPolicy cancellationPolicy) {
            this.cancellationPolicy = Optional.ofNullable(cancellationPolicy);
            return this;
        }

        @JsonSetter(value="cancellation_policy_text", nulls=Nulls.SKIP)
        public Builder cancellationPolicyText(Optional<String> cancellationPolicyText) {
            this.cancellationPolicyText = cancellationPolicyText;
            return this;
        }

        public Builder cancellationPolicyText(String cancellationPolicyText) {
            this.cancellationPolicyText = Optional.ofNullable(cancellationPolicyText);
            return this;
        }

        public Builder cancellationPolicyText(Nullable<String> cancellationPolicyText) {
            this.cancellationPolicyText = cancellationPolicyText.isNull() ? null : (cancellationPolicyText.isEmpty() ? Optional.empty() : Optional.of(cancellationPolicyText.get()));
            return this;
        }

        @JsonSetter(value="skip_booking_flow_staff_selection", nulls=Nulls.SKIP)
        public Builder skipBookingFlowStaffSelection(Optional<Boolean> skipBookingFlowStaffSelection) {
            this.skipBookingFlowStaffSelection = skipBookingFlowStaffSelection;
            return this;
        }

        public Builder skipBookingFlowStaffSelection(Boolean skipBookingFlowStaffSelection) {
            this.skipBookingFlowStaffSelection = Optional.ofNullable(skipBookingFlowStaffSelection);
            return this;
        }

        public Builder skipBookingFlowStaffSelection(Nullable<Boolean> skipBookingFlowStaffSelection) {
            this.skipBookingFlowStaffSelection = skipBookingFlowStaffSelection.isNull() ? null : (skipBookingFlowStaffSelection.isEmpty() ? Optional.empty() : Optional.of(skipBookingFlowStaffSelection.get()));
            return this;
        }

        public BusinessAppointmentSettings build() {
            return new BusinessAppointmentSettings(this.locationTypes, this.alignmentTime, this.minBookingLeadTimeSeconds, this.maxBookingLeadTimeSeconds, this.anyTeamMemberBookingEnabled, this.multipleServiceBookingEnabled, this.maxAppointmentsPerDayLimitType, this.maxAppointmentsPerDayLimit, this.cancellationWindowSeconds, this.cancellationFeeMoney, this.cancellationPolicy, this.cancellationPolicyText, this.skipBookingFlowStaffSelection, this.additionalProperties);
        }
    }
}

