/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BulkUpdateCustomerData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BulkUpdateCustomersRequest {
    private final Map<String, BulkUpdateCustomerData> customers;
    private final Map<String, Object> additionalProperties;

    private BulkUpdateCustomersRequest(Map<String, BulkUpdateCustomerData> customers, Map<String, Object> additionalProperties) {
        this.customers = customers;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customers")
    public Map<String, BulkUpdateCustomerData> getCustomers() {
        return this.customers;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BulkUpdateCustomersRequest && this.equalTo((BulkUpdateCustomersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BulkUpdateCustomersRequest other) {
        return this.customers.equals(other.customers);
    }

    public int hashCode() {
        return Objects.hash(this.customers);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Map<String, BulkUpdateCustomerData> customers = new LinkedHashMap<String, BulkUpdateCustomerData>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BulkUpdateCustomersRequest other) {
            this.customers(other.getCustomers());
            return this;
        }

        @JsonSetter(value="customers", nulls=Nulls.SKIP)
        public Builder customers(Map<String, BulkUpdateCustomerData> customers) {
            this.customers.clear();
            this.customers.putAll(customers);
            return this;
        }

        public Builder putAllCustomers(Map<String, BulkUpdateCustomerData> customers) {
            this.customers.putAll(customers);
            return this;
        }

        public Builder customers(String key, BulkUpdateCustomerData value) {
            this.customers.put(key, value);
            return this;
        }

        public BulkUpdateCustomersRequest build() {
            return new BulkUpdateCustomersRequest(this.customers, this.additionalProperties);
        }
    }
}

