/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BulkCreateCustomerData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BulkCreateCustomersRequest {
    private final Map<String, BulkCreateCustomerData> customers;
    private final Map<String, Object> additionalProperties;

    private BulkCreateCustomersRequest(Map<String, BulkCreateCustomerData> customers, Map<String, Object> additionalProperties) {
        this.customers = customers;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customers")
    public Map<String, BulkCreateCustomerData> getCustomers() {
        return this.customers;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BulkCreateCustomersRequest && this.equalTo((BulkCreateCustomersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BulkCreateCustomersRequest other) {
        return this.customers.equals(other.customers);
    }

    public int hashCode() {
        return Objects.hash(this.customers);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Map<String, BulkCreateCustomerData> customers = new LinkedHashMap<String, BulkCreateCustomerData>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BulkCreateCustomersRequest other) {
            this.customers(other.getCustomers());
            return this;
        }

        @JsonSetter(value="customers", nulls=Nulls.SKIP)
        public Builder customers(Map<String, BulkCreateCustomerData> customers) {
            this.customers.clear();
            this.customers.putAll(customers);
            return this;
        }

        public Builder putAllCustomers(Map<String, BulkCreateCustomerData> customers) {
            this.customers.putAll(customers);
            return this;
        }

        public Builder customers(String key, BulkCreateCustomerData value) {
            this.customers.put(key, value);
            return this;
        }

        public BulkCreateCustomersRequest build() {
            return new BulkCreateCustomersRequest(this.customers, this.additionalProperties);
        }
    }
}

