/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BreakType {
    private final Optional<String> id;
    private final String locationId;
    private final String breakName;
    private final String expectedDuration;
    private final boolean isPaid;
    private final Optional<Integer> version;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Map<String, Object> additionalProperties;

    private BreakType(Optional<String> id, String locationId, String breakName, String expectedDuration, boolean isPaid, Optional<Integer> version, Optional<String> createdAt, Optional<String> updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.locationId = locationId;
        this.breakName = breakName;
        this.expectedDuration = expectedDuration;
        this.isPaid = isPaid;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="break_name")
    public String getBreakName() {
        return this.breakName;
    }

    @JsonProperty(value="expected_duration")
    public String getExpectedDuration() {
        return this.expectedDuration;
    }

    @JsonProperty(value="is_paid")
    public boolean getIsPaid() {
        return this.isPaid;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BreakType && this.equalTo((BreakType)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BreakType other) {
        return this.id.equals(other.id) && this.locationId.equals(other.locationId) && this.breakName.equals(other.breakName) && this.expectedDuration.equals(other.expectedDuration) && this.isPaid == other.isPaid && this.version.equals(other.version) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.breakName, this.expectedDuration, this.isPaid, this.version, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    BreakNameStage,
    ExpectedDurationStage,
    IsPaidStage,
    _FinalStage {
        private String locationId;
        private String breakName;
        private String expectedDuration;
        private boolean isPaid;
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BreakType other) {
            this.id(other.getId());
            this.locationId(other.getLocationId());
            this.breakName(other.getBreakName());
            this.expectedDuration(other.getExpectedDuration());
            this.isPaid(other.getIsPaid());
            this.version(other.getVersion());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public BreakNameStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="break_name")
        public ExpectedDurationStage breakName(@NotNull String breakName) {
            this.breakName = Objects.requireNonNull(breakName, "breakName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="expected_duration")
        public IsPaidStage expectedDuration(@NotNull String expectedDuration) {
            this.expectedDuration = Objects.requireNonNull(expectedDuration, "expectedDuration must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_paid")
        public _FinalStage isPaid(boolean isPaid) {
            this.isPaid = isPaid;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public BreakType build() {
            return new BreakType(this.id, this.locationId, this.breakName, this.expectedDuration, this.isPaid, this.version, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BreakType build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage version(Optional<Integer> var1);

        public _FinalStage version(Integer var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);
    }

    public static interface IsPaidStage {
        public _FinalStage isPaid(boolean var1);
    }

    public static interface ExpectedDurationStage {
        public IsPaidStage expectedDuration(@NotNull String var1);
    }

    public static interface BreakNameStage {
        public ExpectedDurationStage breakName(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public BreakNameStage locationId(@NotNull String var1);

        public Builder from(BreakType var1);
    }
}

