/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Booking;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BookingCreatedEventObject {
    private final Optional<Booking> booking;
    private final Map<String, Object> additionalProperties;

    private BookingCreatedEventObject(Optional<Booking> booking, Map<String, Object> additionalProperties) {
        this.booking = booking;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="booking")
    public Optional<Booking> getBooking() {
        return this.booking;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BookingCreatedEventObject && this.equalTo((BookingCreatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BookingCreatedEventObject other) {
        return this.booking.equals(other.booking);
    }

    public int hashCode() {
        return Objects.hash(this.booking);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Booking> booking = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BookingCreatedEventObject other) {
            this.booking(other.getBooking());
            return this;
        }

        @JsonSetter(value="booking", nulls=Nulls.SKIP)
        public Builder booking(Optional<Booking> booking) {
            this.booking = booking;
            return this;
        }

        public Builder booking(Booking booking) {
            this.booking = Optional.ofNullable(booking);
            return this;
        }

        public BookingCreatedEventObject build() {
            return new BookingCreatedEventObject(this.booking, this.additionalProperties);
        }
    }
}

