/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Order;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchGetOrdersResponse {
    private final Optional<List<Order>> orders;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private BatchGetOrdersResponse(Optional<List<Order>> orders, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.orders = orders;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="orders")
    public Optional<List<Order>> getOrders() {
        return this.orders;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchGetOrdersResponse && this.equalTo((BatchGetOrdersResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchGetOrdersResponse other) {
        return this.orders.equals(other.orders) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.orders, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Order>> orders = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchGetOrdersResponse other) {
            this.orders(other.getOrders());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="orders", nulls=Nulls.SKIP)
        public Builder orders(Optional<List<Order>> orders) {
            this.orders = orders;
            return this;
        }

        public Builder orders(List<Order> orders) {
            this.orders = Optional.ofNullable(orders);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public BatchGetOrdersResponse build() {
            return new BatchGetOrdersResponse(this.orders, this.errors, this.additionalProperties);
        }
    }
}

