/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InventoryState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchGetInventoryCountsRequest {
    private final Optional<List<String>> catalogObjectIds;
    private final Optional<List<String>> locationIds;
    private final Optional<String> updatedAfter;
    private final Optional<String> cursor;
    private final Optional<List<InventoryState>> states;
    private final Optional<Integer> limit;
    private final Map<String, Object> additionalProperties;

    private BatchGetInventoryCountsRequest(Optional<List<String>> catalogObjectIds, Optional<List<String>> locationIds, Optional<String> updatedAfter, Optional<String> cursor, Optional<List<InventoryState>> states, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.catalogObjectIds = catalogObjectIds;
        this.locationIds = locationIds;
        this.updatedAfter = updatedAfter;
        this.cursor = cursor;
        this.states = states;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<String>> getCatalogObjectIds() {
        if (this.catalogObjectIds == null) {
            return Optional.empty();
        }
        return this.catalogObjectIds;
    }

    @JsonIgnore
    public Optional<List<String>> getLocationIds() {
        if (this.locationIds == null) {
            return Optional.empty();
        }
        return this.locationIds;
    }

    @JsonIgnore
    public Optional<String> getUpdatedAfter() {
        if (this.updatedAfter == null) {
            return Optional.empty();
        }
        return this.updatedAfter;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<List<InventoryState>> getStates() {
        if (this.states == null) {
            return Optional.empty();
        }
        return this.states;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_ids")
    private Optional<List<String>> _getCatalogObjectIds() {
        return this.catalogObjectIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_ids")
    private Optional<List<String>> _getLocationIds() {
        return this.locationIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="updated_after")
    private Optional<String> _getUpdatedAfter() {
        return this.updatedAfter;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="states")
    private Optional<List<InventoryState>> _getStates() {
        return this.states;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchGetInventoryCountsRequest && this.equalTo((BatchGetInventoryCountsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchGetInventoryCountsRequest other) {
        return this.catalogObjectIds.equals(other.catalogObjectIds) && this.locationIds.equals(other.locationIds) && this.updatedAfter.equals(other.updatedAfter) && this.cursor.equals(other.cursor) && this.states.equals(other.states) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectIds, this.locationIds, this.updatedAfter, this.cursor, this.states, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> catalogObjectIds = Optional.empty();
        private Optional<List<String>> locationIds = Optional.empty();
        private Optional<String> updatedAfter = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<List<InventoryState>> states = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchGetInventoryCountsRequest other) {
            this.catalogObjectIds(other.getCatalogObjectIds());
            this.locationIds(other.getLocationIds());
            this.updatedAfter(other.getUpdatedAfter());
            this.cursor(other.getCursor());
            this.states(other.getStates());
            this.limit(other.getLimit());
            return this;
        }

        @JsonSetter(value="catalog_object_ids", nulls=Nulls.SKIP)
        public Builder catalogObjectIds(Optional<List<String>> catalogObjectIds) {
            this.catalogObjectIds = catalogObjectIds;
            return this;
        }

        public Builder catalogObjectIds(List<String> catalogObjectIds) {
            this.catalogObjectIds = Optional.ofNullable(catalogObjectIds);
            return this;
        }

        public Builder catalogObjectIds(Nullable<List<String>> catalogObjectIds) {
            this.catalogObjectIds = catalogObjectIds.isNull() ? null : (catalogObjectIds.isEmpty() ? Optional.empty() : Optional.of(catalogObjectIds.get()));
            return this;
        }

        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public Builder locationIds(Optional<List<String>> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = Optional.ofNullable(locationIds);
            return this;
        }

        public Builder locationIds(Nullable<List<String>> locationIds) {
            this.locationIds = locationIds.isNull() ? null : (locationIds.isEmpty() ? Optional.empty() : Optional.of(locationIds.get()));
            return this;
        }

        @JsonSetter(value="updated_after", nulls=Nulls.SKIP)
        public Builder updatedAfter(Optional<String> updatedAfter) {
            this.updatedAfter = updatedAfter;
            return this;
        }

        public Builder updatedAfter(String updatedAfter) {
            this.updatedAfter = Optional.ofNullable(updatedAfter);
            return this;
        }

        public Builder updatedAfter(Nullable<String> updatedAfter) {
            this.updatedAfter = updatedAfter.isNull() ? null : (updatedAfter.isEmpty() ? Optional.empty() : Optional.of(updatedAfter.get()));
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @JsonSetter(value="states", nulls=Nulls.SKIP)
        public Builder states(Optional<List<InventoryState>> states) {
            this.states = states;
            return this;
        }

        public Builder states(List<InventoryState> states) {
            this.states = Optional.ofNullable(states);
            return this;
        }

        public Builder states(Nullable<List<InventoryState>> states) {
            this.states = states.isNull() ? null : (states.isEmpty() ? Optional.empty() : Optional.of(states.get()));
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        public BatchGetInventoryCountsRequest build() {
            return new BatchGetInventoryCountsRequest(this.catalogObjectIds, this.locationIds, this.updatedAfter, this.cursor, this.states, this.limit, this.additionalProperties);
        }
    }
}

