/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchGetCatalogObjectsRequest {
    private final List<String> objectIds;
    private final Optional<Boolean> includeRelatedObjects;
    private final Optional<Long> catalogVersion;
    private final Optional<Boolean> includeDeletedObjects;
    private final Optional<Boolean> includeCategoryPathToRoot;
    private final Map<String, Object> additionalProperties;

    private BatchGetCatalogObjectsRequest(List<String> objectIds, Optional<Boolean> includeRelatedObjects, Optional<Long> catalogVersion, Optional<Boolean> includeDeletedObjects, Optional<Boolean> includeCategoryPathToRoot, Map<String, Object> additionalProperties) {
        this.objectIds = objectIds;
        this.includeRelatedObjects = includeRelatedObjects;
        this.catalogVersion = catalogVersion;
        this.includeDeletedObjects = includeDeletedObjects;
        this.includeCategoryPathToRoot = includeCategoryPathToRoot;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="object_ids")
    public List<String> getObjectIds() {
        return this.objectIds;
    }

    @JsonIgnore
    public Optional<Boolean> getIncludeRelatedObjects() {
        if (this.includeRelatedObjects == null) {
            return Optional.empty();
        }
        return this.includeRelatedObjects;
    }

    @JsonIgnore
    public Optional<Long> getCatalogVersion() {
        if (this.catalogVersion == null) {
            return Optional.empty();
        }
        return this.catalogVersion;
    }

    @JsonIgnore
    public Optional<Boolean> getIncludeDeletedObjects() {
        if (this.includeDeletedObjects == null) {
            return Optional.empty();
        }
        return this.includeDeletedObjects;
    }

    @JsonIgnore
    public Optional<Boolean> getIncludeCategoryPathToRoot() {
        if (this.includeCategoryPathToRoot == null) {
            return Optional.empty();
        }
        return this.includeCategoryPathToRoot;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="include_related_objects")
    private Optional<Boolean> _getIncludeRelatedObjects() {
        return this.includeRelatedObjects;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_version")
    private Optional<Long> _getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="include_deleted_objects")
    private Optional<Boolean> _getIncludeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="include_category_path_to_root")
    private Optional<Boolean> _getIncludeCategoryPathToRoot() {
        return this.includeCategoryPathToRoot;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchGetCatalogObjectsRequest && this.equalTo((BatchGetCatalogObjectsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchGetCatalogObjectsRequest other) {
        return this.objectIds.equals(other.objectIds) && this.includeRelatedObjects.equals(other.includeRelatedObjects) && this.catalogVersion.equals(other.catalogVersion) && this.includeDeletedObjects.equals(other.includeDeletedObjects) && this.includeCategoryPathToRoot.equals(other.includeCategoryPathToRoot);
    }

    public int hashCode() {
        return Objects.hash(this.objectIds, this.includeRelatedObjects, this.catalogVersion, this.includeDeletedObjects, this.includeCategoryPathToRoot);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> objectIds = new ArrayList<String>();
        private Optional<Boolean> includeRelatedObjects = Optional.empty();
        private Optional<Long> catalogVersion = Optional.empty();
        private Optional<Boolean> includeDeletedObjects = Optional.empty();
        private Optional<Boolean> includeCategoryPathToRoot = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchGetCatalogObjectsRequest other) {
            this.objectIds(other.getObjectIds());
            this.includeRelatedObjects(other.getIncludeRelatedObjects());
            this.catalogVersion(other.getCatalogVersion());
            this.includeDeletedObjects(other.getIncludeDeletedObjects());
            this.includeCategoryPathToRoot(other.getIncludeCategoryPathToRoot());
            return this;
        }

        @JsonSetter(value="object_ids", nulls=Nulls.SKIP)
        public Builder objectIds(List<String> objectIds) {
            this.objectIds.clear();
            this.objectIds.addAll(objectIds);
            return this;
        }

        public Builder addObjectIds(String objectIds) {
            this.objectIds.add(objectIds);
            return this;
        }

        public Builder addAllObjectIds(List<String> objectIds) {
            this.objectIds.addAll(objectIds);
            return this;
        }

        @JsonSetter(value="include_related_objects", nulls=Nulls.SKIP)
        public Builder includeRelatedObjects(Optional<Boolean> includeRelatedObjects) {
            this.includeRelatedObjects = includeRelatedObjects;
            return this;
        }

        public Builder includeRelatedObjects(Boolean includeRelatedObjects) {
            this.includeRelatedObjects = Optional.ofNullable(includeRelatedObjects);
            return this;
        }

        public Builder includeRelatedObjects(Nullable<Boolean> includeRelatedObjects) {
            this.includeRelatedObjects = includeRelatedObjects.isNull() ? null : (includeRelatedObjects.isEmpty() ? Optional.empty() : Optional.of(includeRelatedObjects.get()));
            return this;
        }

        @JsonSetter(value="catalog_version", nulls=Nulls.SKIP)
        public Builder catalogVersion(Optional<Long> catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = Optional.ofNullable(catalogVersion);
            return this;
        }

        public Builder catalogVersion(Nullable<Long> catalogVersion) {
            this.catalogVersion = catalogVersion.isNull() ? null : (catalogVersion.isEmpty() ? Optional.empty() : Optional.of(catalogVersion.get()));
            return this;
        }

        @JsonSetter(value="include_deleted_objects", nulls=Nulls.SKIP)
        public Builder includeDeletedObjects(Optional<Boolean> includeDeletedObjects) {
            this.includeDeletedObjects = includeDeletedObjects;
            return this;
        }

        public Builder includeDeletedObjects(Boolean includeDeletedObjects) {
            this.includeDeletedObjects = Optional.ofNullable(includeDeletedObjects);
            return this;
        }

        public Builder includeDeletedObjects(Nullable<Boolean> includeDeletedObjects) {
            this.includeDeletedObjects = includeDeletedObjects.isNull() ? null : (includeDeletedObjects.isEmpty() ? Optional.empty() : Optional.of(includeDeletedObjects.get()));
            return this;
        }

        @JsonSetter(value="include_category_path_to_root", nulls=Nulls.SKIP)
        public Builder includeCategoryPathToRoot(Optional<Boolean> includeCategoryPathToRoot) {
            this.includeCategoryPathToRoot = includeCategoryPathToRoot;
            return this;
        }

        public Builder includeCategoryPathToRoot(Boolean includeCategoryPathToRoot) {
            this.includeCategoryPathToRoot = Optional.ofNullable(includeCategoryPathToRoot);
            return this;
        }

        public Builder includeCategoryPathToRoot(Nullable<Boolean> includeCategoryPathToRoot) {
            this.includeCategoryPathToRoot = includeCategoryPathToRoot.isNull() ? null : (includeCategoryPathToRoot.isEmpty() ? Optional.empty() : Optional.of(includeCategoryPathToRoot.get()));
            return this;
        }

        public BatchGetCatalogObjectsRequest build() {
            return new BatchGetCatalogObjectsRequest(this.objectIds, this.includeRelatedObjects, this.catalogVersion, this.includeDeletedObjects, this.includeCategoryPathToRoot, this.additionalProperties);
        }
    }
}

