/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CreateVendorResponse;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchCreateVendorsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Map<String, CreateVendorResponse>> responses;
    private final Map<String, Object> additionalProperties;

    private BatchCreateVendorsResponse(Optional<List<Error>> errors, Optional<Map<String, CreateVendorResponse>> responses, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.responses = responses;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="responses")
    public Optional<Map<String, CreateVendorResponse>> getResponses() {
        return this.responses;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchCreateVendorsResponse && this.equalTo((BatchCreateVendorsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchCreateVendorsResponse other) {
        return this.errors.equals(other.errors) && this.responses.equals(other.responses);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.responses);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Map<String, CreateVendorResponse>> responses = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchCreateVendorsResponse other) {
            this.errors(other.getErrors());
            this.responses(other.getResponses());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="responses", nulls=Nulls.SKIP)
        public Builder responses(Optional<Map<String, CreateVendorResponse>> responses) {
            this.responses = responses;
            return this;
        }

        public Builder responses(Map<String, CreateVendorResponse> responses) {
            this.responses = Optional.ofNullable(responses);
            return this;
        }

        public BatchCreateVendorsResponse build() {
            return new BatchCreateVendorsResponse(this.errors, this.responses, this.additionalProperties);
        }
    }
}

