/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InventoryChange;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchChangeInventoryRequest {
    private final String idempotencyKey;
    private final Optional<List<InventoryChange>> changes;
    private final Optional<Boolean> ignoreUnchangedCounts;
    private final Map<String, Object> additionalProperties;

    private BatchChangeInventoryRequest(String idempotencyKey, Optional<List<InventoryChange>> changes, Optional<Boolean> ignoreUnchangedCounts, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.changes = changes;
        this.ignoreUnchangedCounts = ignoreUnchangedCounts;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public Optional<List<InventoryChange>> getChanges() {
        if (this.changes == null) {
            return Optional.empty();
        }
        return this.changes;
    }

    @JsonIgnore
    public Optional<Boolean> getIgnoreUnchangedCounts() {
        if (this.ignoreUnchangedCounts == null) {
            return Optional.empty();
        }
        return this.ignoreUnchangedCounts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="changes")
    private Optional<List<InventoryChange>> _getChanges() {
        return this.changes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ignore_unchanged_counts")
    private Optional<Boolean> _getIgnoreUnchangedCounts() {
        return this.ignoreUnchangedCounts;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchChangeInventoryRequest && this.equalTo((BatchChangeInventoryRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchChangeInventoryRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.changes.equals(other.changes) && this.ignoreUnchangedCounts.equals(other.ignoreUnchangedCounts);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.changes, this.ignoreUnchangedCounts);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    _FinalStage {
        private String idempotencyKey;
        private Optional<Boolean> ignoreUnchangedCounts = Optional.empty();
        private Optional<List<InventoryChange>> changes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BatchChangeInventoryRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.changes(other.getChanges());
            this.ignoreUnchangedCounts(other.getIgnoreUnchangedCounts());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public _FinalStage ignoreUnchangedCounts(Nullable<Boolean> ignoreUnchangedCounts) {
            this.ignoreUnchangedCounts = ignoreUnchangedCounts.isNull() ? null : (ignoreUnchangedCounts.isEmpty() ? Optional.empty() : Optional.of(ignoreUnchangedCounts.get()));
            return this;
        }

        @Override
        public _FinalStage ignoreUnchangedCounts(Boolean ignoreUnchangedCounts) {
            this.ignoreUnchangedCounts = Optional.ofNullable(ignoreUnchangedCounts);
            return this;
        }

        @Override
        @JsonSetter(value="ignore_unchanged_counts", nulls=Nulls.SKIP)
        public _FinalStage ignoreUnchangedCounts(Optional<Boolean> ignoreUnchangedCounts) {
            this.ignoreUnchangedCounts = ignoreUnchangedCounts;
            return this;
        }

        @Override
        public _FinalStage changes(Nullable<List<InventoryChange>> changes) {
            this.changes = changes.isNull() ? null : (changes.isEmpty() ? Optional.empty() : Optional.of(changes.get()));
            return this;
        }

        @Override
        public _FinalStage changes(List<InventoryChange> changes) {
            this.changes = Optional.ofNullable(changes);
            return this;
        }

        @Override
        @JsonSetter(value="changes", nulls=Nulls.SKIP)
        public _FinalStage changes(Optional<List<InventoryChange>> changes) {
            this.changes = changes;
            return this;
        }

        @Override
        public BatchChangeInventoryRequest build() {
            return new BatchChangeInventoryRequest(this.idempotencyKey, this.changes, this.ignoreUnchangedCounts, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BatchChangeInventoryRequest build();

        public _FinalStage changes(Optional<List<InventoryChange>> var1);

        public _FinalStage changes(List<InventoryChange> var1);

        public _FinalStage changes(Nullable<List<InventoryChange>> var1);

        public _FinalStage ignoreUnchangedCounts(Optional<Boolean> var1);

        public _FinalStage ignoreUnchangedCounts(Boolean var1);

        public _FinalStage ignoreUnchangedCounts(Nullable<Boolean> var1);
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);

        public Builder from(BatchChangeInventoryRequest var1);
    }
}

