/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class BankAccountStatus {
    public static final BankAccountStatus VERIFIED = new BankAccountStatus(Value.VERIFIED, "VERIFIED");
    public static final BankAccountStatus DISABLED = new BankAccountStatus(Value.DISABLED, "DISABLED");
    public static final BankAccountStatus VERIFICATION_IN_PROGRESS = new BankAccountStatus(Value.VERIFICATION_IN_PROGRESS, "VERIFICATION_IN_PROGRESS");
    private final Value value;
    private final String string;

    BankAccountStatus(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof BankAccountStatus && this.string.equals(((BankAccountStatus)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case VERIFIED: {
                return visitor.visitVerified();
            }
            case DISABLED: {
                return visitor.visitDisabled();
            }
            case VERIFICATION_IN_PROGRESS: {
                return visitor.visitVerificationInProgress();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static BankAccountStatus valueOf(String value) {
        switch (value) {
            case "VERIFIED": {
                return VERIFIED;
            }
            case "DISABLED": {
                return DISABLED;
            }
            case "VERIFICATION_IN_PROGRESS": {
                return VERIFICATION_IN_PROGRESS;
            }
        }
        return new BankAccountStatus(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitVerificationInProgress();

        public T visitVerified();

        public T visitDisabled();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        VERIFICATION_IN_PROGRESS,
        VERIFIED,
        DISABLED,
        UNKNOWN;

    }
}

