/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BankAccount;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BankAccountCreatedEventObject {
    private final Optional<BankAccount> bankAccount;
    private final Map<String, Object> additionalProperties;

    private BankAccountCreatedEventObject(Optional<BankAccount> bankAccount, Map<String, Object> additionalProperties) {
        this.bankAccount = bankAccount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="bank_account")
    public Optional<BankAccount> getBankAccount() {
        return this.bankAccount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BankAccountCreatedEventObject && this.equalTo((BankAccountCreatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BankAccountCreatedEventObject other) {
        return this.bankAccount.equals(other.bankAccount);
    }

    public int hashCode() {
        return Objects.hash(this.bankAccount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<BankAccount> bankAccount = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BankAccountCreatedEventObject other) {
            this.bankAccount(other.getBankAccount());
            return this;
        }

        @JsonSetter(value="bank_account", nulls=Nulls.SKIP)
        public Builder bankAccount(Optional<BankAccount> bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public Builder bankAccount(BankAccount bankAccount) {
            this.bankAccount = Optional.ofNullable(bankAccount);
            return this;
        }

        public BankAccountCreatedEventObject build() {
            return new BankAccountCreatedEventObject(this.bankAccount, this.additionalProperties);
        }
    }
}

