/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AdditionalRecipient {
    private final String locationId;
    private final Optional<String> description;
    private final Money amountMoney;
    private final Optional<String> receivableId;
    private final Map<String, Object> additionalProperties;

    private AdditionalRecipient(String locationId, Optional<String> description, Money amountMoney, Optional<String> receivableId, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.description = description;
        this.amountMoney = amountMoney;
        this.receivableId = receivableId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonIgnore
    public Optional<String> getReceivableId() {
        if (this.receivableId == null) {
            return Optional.empty();
        }
        return this.receivableId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="receivable_id")
    private Optional<String> _getReceivableId() {
        return this.receivableId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AdditionalRecipient && this.equalTo((AdditionalRecipient)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdditionalRecipient other) {
        return this.locationId.equals(other.locationId) && this.description.equals(other.description) && this.amountMoney.equals(other.amountMoney) && this.receivableId.equals(other.receivableId);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.description, this.amountMoney, this.receivableId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    AmountMoneyStage,
    _FinalStage {
        private String locationId;
        private Money amountMoney;
        private Optional<String> receivableId = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AdditionalRecipient other) {
            this.locationId(other.getLocationId());
            this.description(other.getDescription());
            this.amountMoney(other.getAmountMoney());
            this.receivableId(other.getReceivableId());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public AmountMoneyStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public _FinalStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        public _FinalStage receivableId(Nullable<String> receivableId) {
            this.receivableId = receivableId.isNull() ? null : (receivableId.isEmpty() ? Optional.empty() : Optional.of(receivableId.get()));
            return this;
        }

        @Override
        public _FinalStage receivableId(String receivableId) {
            this.receivableId = Optional.ofNullable(receivableId);
            return this;
        }

        @Override
        @JsonSetter(value="receivable_id", nulls=Nulls.SKIP)
        public _FinalStage receivableId(Optional<String> receivableId) {
            this.receivableId = receivableId;
            return this;
        }

        @Override
        public _FinalStage description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public AdditionalRecipient build() {
            return new AdditionalRecipient(this.locationId, this.description, this.amountMoney, this.receivableId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AdditionalRecipient build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage description(Nullable<String> var1);

        public _FinalStage receivableId(Optional<String> var1);

        public _FinalStage receivableId(String var1);

        public _FinalStage receivableId(Nullable<String> var1);
    }

    public static interface AmountMoneyStage {
        public _FinalStage amountMoney(@NotNull Money var1);
    }

    public static interface LocationIdStage {
        public AmountMoneyStage locationId(@NotNull String var1);

        public Builder from(AdditionalRecipient var1);
    }
}

