/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AcceptedPaymentMethods {
    private final Optional<Boolean> applePay;
    private final Optional<Boolean> googlePay;
    private final Optional<Boolean> cashAppPay;
    private final Optional<Boolean> afterpayClearpay;
    private final Map<String, Object> additionalProperties;

    private AcceptedPaymentMethods(Optional<Boolean> applePay, Optional<Boolean> googlePay, Optional<Boolean> cashAppPay, Optional<Boolean> afterpayClearpay, Map<String, Object> additionalProperties) {
        this.applePay = applePay;
        this.googlePay = googlePay;
        this.cashAppPay = cashAppPay;
        this.afterpayClearpay = afterpayClearpay;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Boolean> getApplePay() {
        if (this.applePay == null) {
            return Optional.empty();
        }
        return this.applePay;
    }

    @JsonIgnore
    public Optional<Boolean> getGooglePay() {
        if (this.googlePay == null) {
            return Optional.empty();
        }
        return this.googlePay;
    }

    @JsonIgnore
    public Optional<Boolean> getCashAppPay() {
        if (this.cashAppPay == null) {
            return Optional.empty();
        }
        return this.cashAppPay;
    }

    @JsonIgnore
    public Optional<Boolean> getAfterpayClearpay() {
        if (this.afterpayClearpay == null) {
            return Optional.empty();
        }
        return this.afterpayClearpay;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="apple_pay")
    private Optional<Boolean> _getApplePay() {
        return this.applePay;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="google_pay")
    private Optional<Boolean> _getGooglePay() {
        return this.googlePay;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cash_app_pay")
    private Optional<Boolean> _getCashAppPay() {
        return this.cashAppPay;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="afterpay_clearpay")
    private Optional<Boolean> _getAfterpayClearpay() {
        return this.afterpayClearpay;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AcceptedPaymentMethods && this.equalTo((AcceptedPaymentMethods)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AcceptedPaymentMethods other) {
        return this.applePay.equals(other.applePay) && this.googlePay.equals(other.googlePay) && this.cashAppPay.equals(other.cashAppPay) && this.afterpayClearpay.equals(other.afterpayClearpay);
    }

    public int hashCode() {
        return Objects.hash(this.applePay, this.googlePay, this.cashAppPay, this.afterpayClearpay);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> applePay = Optional.empty();
        private Optional<Boolean> googlePay = Optional.empty();
        private Optional<Boolean> cashAppPay = Optional.empty();
        private Optional<Boolean> afterpayClearpay = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(AcceptedPaymentMethods other) {
            this.applePay(other.getApplePay());
            this.googlePay(other.getGooglePay());
            this.cashAppPay(other.getCashAppPay());
            this.afterpayClearpay(other.getAfterpayClearpay());
            return this;
        }

        @JsonSetter(value="apple_pay", nulls=Nulls.SKIP)
        public Builder applePay(Optional<Boolean> applePay) {
            this.applePay = applePay;
            return this;
        }

        public Builder applePay(Boolean applePay) {
            this.applePay = Optional.ofNullable(applePay);
            return this;
        }

        public Builder applePay(Nullable<Boolean> applePay) {
            this.applePay = applePay.isNull() ? null : (applePay.isEmpty() ? Optional.empty() : Optional.of(applePay.get()));
            return this;
        }

        @JsonSetter(value="google_pay", nulls=Nulls.SKIP)
        public Builder googlePay(Optional<Boolean> googlePay) {
            this.googlePay = googlePay;
            return this;
        }

        public Builder googlePay(Boolean googlePay) {
            this.googlePay = Optional.ofNullable(googlePay);
            return this;
        }

        public Builder googlePay(Nullable<Boolean> googlePay) {
            this.googlePay = googlePay.isNull() ? null : (googlePay.isEmpty() ? Optional.empty() : Optional.of(googlePay.get()));
            return this;
        }

        @JsonSetter(value="cash_app_pay", nulls=Nulls.SKIP)
        public Builder cashAppPay(Optional<Boolean> cashAppPay) {
            this.cashAppPay = cashAppPay;
            return this;
        }

        public Builder cashAppPay(Boolean cashAppPay) {
            this.cashAppPay = Optional.ofNullable(cashAppPay);
            return this;
        }

        public Builder cashAppPay(Nullable<Boolean> cashAppPay) {
            this.cashAppPay = cashAppPay.isNull() ? null : (cashAppPay.isEmpty() ? Optional.empty() : Optional.of(cashAppPay.get()));
            return this;
        }

        @JsonSetter(value="afterpay_clearpay", nulls=Nulls.SKIP)
        public Builder afterpayClearpay(Optional<Boolean> afterpayClearpay) {
            this.afterpayClearpay = afterpayClearpay;
            return this;
        }

        public Builder afterpayClearpay(Boolean afterpayClearpay) {
            this.afterpayClearpay = Optional.ofNullable(afterpayClearpay);
            return this;
        }

        public Builder afterpayClearpay(Nullable<Boolean> afterpayClearpay) {
            this.afterpayClearpay = afterpayClearpay.isNull() ? null : (afterpayClearpay.isEmpty() ? Optional.empty() : Optional.of(afterpayClearpay.get()));
            return this;
        }

        public AcceptedPaymentMethods build() {
            return new AcceptedPaymentMethods(this.applePay, this.googlePay, this.cashAppPay, this.afterpayClearpay, this.additionalProperties);
        }
    }
}

