/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.terminal.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TerminalCheckoutQuery;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchTerminalCheckoutsRequest {
    private final Optional<TerminalCheckoutQuery> query;
    private final Optional<String> cursor;
    private final Optional<Integer> limit;
    private final Map<String, Object> additionalProperties;

    private SearchTerminalCheckoutsRequest(Optional<TerminalCheckoutQuery> query, Optional<String> cursor, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.query = query;
        this.cursor = cursor;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="query")
    public Optional<TerminalCheckoutQuery> getQuery() {
        return this.query;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchTerminalCheckoutsRequest && this.equalTo((SearchTerminalCheckoutsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchTerminalCheckoutsRequest other) {
        return this.query.equals(other.query) && this.cursor.equals(other.cursor) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.cursor, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<TerminalCheckoutQuery> query = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchTerminalCheckoutsRequest other) {
            this.query(other.getQuery());
            this.cursor(other.getCursor());
            this.limit(other.getLimit());
            return this;
        }

        @JsonSetter(value="query", nulls=Nulls.SKIP)
        public Builder query(Optional<TerminalCheckoutQuery> query) {
            this.query = query;
            return this;
        }

        public Builder query(TerminalCheckoutQuery query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public SearchTerminalCheckoutsRequest build() {
            return new SearchTerminalCheckoutsRequest(this.query, this.cursor, this.limit, this.additionalProperties);
        }
    }
}

