/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.terminal.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TerminalCheckout;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateTerminalCheckoutRequest {
    private final String idempotencyKey;
    private final TerminalCheckout checkout;
    private final Map<String, Object> additionalProperties;

    private CreateTerminalCheckoutRequest(String idempotencyKey, TerminalCheckout checkout, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.checkout = checkout;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="checkout")
    public TerminalCheckout getCheckout() {
        return this.checkout;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateTerminalCheckoutRequest && this.equalTo((CreateTerminalCheckoutRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateTerminalCheckoutRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.checkout.equals(other.checkout);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.checkout);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    CheckoutStage,
    _FinalStage {
        private String idempotencyKey;
        private TerminalCheckout checkout;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateTerminalCheckoutRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.checkout(other.getCheckout());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public CheckoutStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="checkout")
        public _FinalStage checkout(@NotNull TerminalCheckout checkout) {
            this.checkout = Objects.requireNonNull(checkout, "checkout must not be null");
            return this;
        }

        @Override
        public CreateTerminalCheckoutRequest build() {
            return new CreateTerminalCheckoutRequest(this.idempotencyKey, this.checkout, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateTerminalCheckoutRequest build();
    }

    public static interface CheckoutStage {
        public _FinalStage checkout(@NotNull TerminalCheckout var1);
    }

    public static interface IdempotencyKeyStage {
        public CheckoutStage idempotencyKey(@NotNull String var1);

        public Builder from(CreateTerminalCheckoutRequest var1);
    }
}

